/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.linear;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import javax.constraints.ConstrainedVariable;
import javax.constraints.Constraint;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.impl.AbstractConstrainedVariable;
import javax.constraints.impl.Problem;

public class MpsGenerator {
    Problem problem;
    int objectiveDirection;
    AbstractConstrainedVariable objectiveVar;
    private String[] rowNames;
    private String[] rowTypes;
    private double[] rowValues;
    private int rowCount = 1;
    public static final String OBJ = "N";
    public static final String OBJ_ID = "_OBJ_";
    public static final int[] colStarts = new int[]{0, 4, 14, 24, 39, 49};
    public static final int[] colLengths = new int[]{10, 15};
    private boolean integerVariablesOnly;
    private int maxNameSize;
    BufferedWriter output;
    static final String LP_DECIMAL_FORMAT = "#0.000";
    static String REAL_FORMAT = "#,##0.00";
    static DecimalFormat DEFAULT_REAL_FORMAT = new DecimalFormat("#0.000");

    public MpsGenerator(Problem problem, int objectiveDirection, AbstractConstrainedVariable objectiveVar, File file) {
        VarReal[] varReals;
        this.problem = problem;
        this.objectiveDirection = objectiveDirection;
        this.objectiveVar = objectiveVar;
        System.out.println("MpsGenerator for file " + file.getAbsolutePath());
        this.setIntegerVariablesOnly(false);
        Constraint[] constraints = problem.getConstraints();
        this.rowNames = new String[constraints.length];
        this.rowTypes = new String[constraints.length];
        this.rowValues = new double[constraints.length];
        this.maxNameSize = 0;
        Var[] vars = problem.getVars();
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                if (vars[i].getName().length() <= this.maxNameSize) continue;
                this.maxNameSize = vars[i].getName().length();
            }
        }
        if ((varReals = problem.getVarReals()) != null) {
            for (int i = 0; i < varReals.length; ++i) {
                if (varReals[i].getName().length() <= this.maxNameSize) continue;
                this.maxNameSize = varReals[i].getName().length();
            }
        }
        double precision = 1.0;
        if (this.isIntegerVariablesOnly()) {
            precision = 1.0;
        }
        for (int i = 0; i < constraints.length; ++i) {
            javax.constraints.impl.Constraint c = (javax.constraints.impl.Constraint)constraints[i];
            this.rowNames[i] = c.getName();
            this.rowValues[i] = c.getValue();
            String oper = c.getOper();
            if (">".equals(oper)) {
                oper = ">=";
                int n = i;
                this.rowValues[n] = this.rowValues[n] + precision;
            }
            if ("<".equals(oper)) {
                oper = "<=";
                int n = i;
                this.rowValues[n] = this.rowValues[n] - precision;
            }
            this.rowTypes[i] = this.getRowType(oper);
        }
        try {
            this.output = new BufferedWriter(new FileWriter(file));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MpsGenerator cannot write to the given file");
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void incrementRowCount() {
        ++this.rowCount;
    }

    void write(String text) {
        try {
            this.output.write(text);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("MpsGenerator: error writing to the given file");
        }
    }

    public boolean isIntegerVariablesOnly() {
        return this.integerVariablesOnly;
    }

    public void setIntegerVariablesOnly(boolean integerVariablesOnly) {
        this.integerVariablesOnly = integerVariablesOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate() {
        long startTime = System.currentTimeMillis();
        try {
            this.write("NAME          " + this.problem.getName() + "\n");
            int pos = 1;
            while (this.maxNameSize + 5 > colStarts[++pos]) {
            }
            this.writeRows();
            this.writeColumns(colStarts[pos]);
            this.writeRHS(colStarts[pos]);
            this.writeBounds(colStarts[pos]);
            this.write("ENDATA");
            this.write("\n");
        }
        finally {
            try {
                this.output.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("MpsGenerator: cannot close the given file");
            }
        }
        long executionTime = System.currentTimeMillis() - startTime;
        System.out.println("MPS file generated in " + executionTime + " msec");
    }

    private void writeRows() {
        this.write("ROWS\n");
        if (!this.problem.isDerivedVar(this.objectiveVar)) {
            System.out.println("Objective variable " + this.objectiveVar.getName() + " is not derived from other variables");
        }
        this.write(" N  _OBJ_\n");
        Constraint[] constraints = this.problem.getConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            this.write(" " + this.rowTypes[i] + "  " + this.rowNames[i] + "\n");
        }
    }

    private void writeColumns(int thirdColStart) {
        VarReal[] varReals;
        double d;
        String rowName;
        String str;
        int k;
        this.write("COLUMNS");
        Constraint[] constraints = this.problem.getConstraints();
        Var[] vars = this.problem.getVars();
        if (vars != null) {
            this.startIntegerMarker(0);
            for (int i = 0; i < vars.length; ++i) {
                javax.constraints.impl.Var var = (javax.constraints.impl.Var)vars[i];
                var.setId("Vi" + i);
                var.setUsedInConstraints(false);
                int count = 0;
                block1: for (int j = 0; j < constraints.length; ++j) {
                    javax.constraints.impl.Constraint c = (javax.constraints.impl.Constraint)constraints[j];
                    double[] constraintCoefficients = c.getCoefficients();
                    ConstrainedVariable[] constraintVars = c.getVars();
                    boolean[] written = new boolean[constraintCoefficients.length];
                    for (int w = 0; w < written.length; ++w) {
                        written[w] = false;
                    }
                    for (k = 0; k < constraintVars.length; ++k) {
                        if (!((Object)((Object)var)).equals(constraintVars[k])) continue;
                        if (!var.isUsedInConstraints()) {
                            var.setUsedInConstraints(true);
                        }
                        if (count % 2 == 0) {
                            str = "    " + var.getId();
                            str = this.rightPadWhitespace(str, thirdColStart);
                            this.write("\n" + str);
                        }
                        rowName = c.getName();
                        d = constraintCoefficients[k];
                        this.writeColumn(rowName, d);
                        ++count;
                        continue block1;
                    }
                }
            }
            this.endIntegerMarker(1);
        }
        if ((varReals = this.problem.getVarReals()) != null) {
            for (int i = 0; i < varReals.length; ++i) {
                javax.constraints.impl.VarReal var = (javax.constraints.impl.VarReal)varReals[i];
                var.setId("Vr" + i);
                var.setUsedInConstraints(false);
                int count = 0;
                block5: for (int j = 0; j < constraints.length; ++j) {
                    javax.constraints.impl.Constraint c = (javax.constraints.impl.Constraint)constraints[j];
                    double[] constraintCoefficients = c.getCoefficients();
                    ConstrainedVariable[] constraintVars = c.getVars();
                    for (k = 0; k < constraintVars.length; ++k) {
                        if (!((Object)((Object)var)).equals(constraintVars[k])) continue;
                        if (!var.isUsedInConstraints()) {
                            var.setUsedInConstraints(true);
                        }
                        if (count % 2 == 0) {
                            str = "    " + var.getId();
                            str = this.rightPadWhitespace(str, thirdColStart);
                            this.write("\n" + str);
                        }
                        rowName = c.getName();
                        d = constraintCoefficients[k];
                        this.writeColumn(rowName, d);
                        ++count;
                        continue block5;
                    }
                }
            }
        }
        String str2 = "    " + this.objectiveVar.getId();
        str2 = this.rightPadWhitespace(str2, thirdColStart);
        this.write("\n" + str2);
        this.writeColumn(OBJ_ID, this.objectiveDirection);
        this.write("\n");
    }

    private void writeColumn(String rowName, double d) {
        rowName = this.rightPadWhitespace(rowName, colLengths[0]);
        String rCoeff = "";
        rCoeff = Math.floor(d) == d ? rCoeff + (int)d + "   " : rCoeff + MpsGenerator.format(d) + "   ";
        rCoeff = this.leftPadWhitespace(rCoeff, colLengths[1]);
        this.write(rowName + rCoeff);
    }

    private void startIntegerMarker(int markerCount) {
        String marker = "" + markerCount;
        while (marker.length() < 4) {
            marker = "0" + marker;
        }
        marker = "\n    M" + marker + "     'MARKER'                 'INTORG'";
        this.write(marker);
    }

    private void endIntegerMarker(int markerCount) {
        String marker = "" + markerCount;
        while (marker.length() < 4) {
            marker = "0" + marker;
        }
        marker = "\n    M" + marker + "     'MARKER'                 'INTEND'";
        this.write(marker);
    }

    private void writeRHS(int thirdColStart) {
        this.write("RHS");
        int count = 0;
        for (int r = 0; r < this.rowNames.length; ++r) {
            String rName = this.rowNames[r];
            rName = this.rightPadWhitespace(rName, colLengths[0]);
            double d = this.rowValues[r];
            String rRHS = "";
            rRHS = Math.floor(d) == d ? rRHS + (int)d + "   " : rRHS + MpsGenerator.format(d) + "   ";
            rRHS = this.leftPadWhitespace(rRHS, colLengths[1]);
            if (!(d > 0.0)) continue;
            if (count % 2 == 0) {
                String str = "    rhs";
                str = this.rightPadWhitespace(str, thirdColStart);
                this.write("\n" + str);
            }
            this.write(rName + rRHS);
            ++count;
        }
        this.write("\n");
    }

    private void writeBounds(int thirdColStart) {
        VarReal[] varReals;
        this.write("BOUNDS\n");
        Var[] vars = this.problem.getVars();
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                javax.constraints.impl.Var var = (javax.constraints.impl.Var)vars[i];
                if (!var.isUsedInConstraints()) continue;
                this.writeOneBounds(var.getId(), var.getMin(), var.getMax(), thirdColStart);
            }
        }
        if ((varReals = this.problem.getVarReals()) != null) {
            for (int i = 0; i < varReals.length; ++i) {
                javax.constraints.impl.VarReal varReal = (javax.constraints.impl.VarReal)varReals[i];
                if (!varReal.isUsedInConstraints()) continue;
                this.writeOneBounds(varReal.getId(), varReal.getMin(), varReal.getMax(), thirdColStart);
            }
        }
    }

    private void writeOneBounds(String name, double min, double max, int thirdColStart) {
        String str = " UP bnd";
        str = this.rightPadWhitespace(str, thirdColStart);
        String vName = name;
        vName = this.rightPadWhitespace(vName, colLengths[0]);
        double d = max;
        String vUppBnd = "";
        vUppBnd = Math.floor(d) == d ? vUppBnd + (int)d + "   " : vUppBnd + MpsGenerator.format(d) + "   ";
        vUppBnd = this.leftPadWhitespace(vUppBnd, colLengths[1]);
        this.write(str + vName + vUppBnd + "\n");
        double lb = min;
        if (lb > 0.0) {
            String str2 = " LO bnd";
            str2 = this.rightPadWhitespace(str2, thirdColStart);
            String vLowBnd = "";
            vLowBnd = Math.floor(lb) == lb ? vLowBnd + (int)lb + "   " : vLowBnd + MpsGenerator.format(lb) + "   ";
            vLowBnd = this.leftPadWhitespace(vLowBnd, colLengths[1]);
            this.write(str2 + vName + vLowBnd + "\n");
        }
    }

    private String rightPadWhitespace(String str, int length) {
        while (str.length() < length) {
            str = str + " ";
        }
        return str;
    }

    private String leftPadWhitespace(String str, int length) {
        while (str.length() < length) {
            str = " " + str;
        }
        return str;
    }

    private String getRowType(String oper) {
        if (oper.equals("=")) {
            return "E";
        }
        if (oper.equals("<=")) {
            return "L";
        }
        if (oper.equals(">=")) {
            return "G";
        }
        throw new RuntimeException("Illegal operator " + oper);
    }

    public static String format(double d, String fmt) {
        DecimalFormat df = new DecimalFormat(fmt);
        return df.format(d);
    }

    public static String format(double d) {
        return DEFAULT_REAL_FORMAT.format(d);
    }

    public static void setRealFormat(String fmt) {
        REAL_FORMAT = fmt;
    }

    public static String getRealFormat() {
        return REAL_FORMAT;
    }
}

