/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.linear;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.concurrent.TimeUnit;

public class StreamGobbler
extends Thread {
    InputStream is;
    String type;
    OutputStream os;

    StreamGobbler(InputStream is, String type) {
        this(is, type, null);
    }

    StreamGobbler(InputStream is, String type, OutputStream redirect) {
        this.is = is;
        this.type = type;
        this.os = redirect;
    }

    @Override
    public void run() {
        try {
            PrintWriter pw = null;
            if (this.os != null) {
                pw = new PrintWriter(this.os);
            }
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (pw == null) continue;
                pw.println(line);
            }
            if (pw != null) {
                pw.flush();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void execute(String command, String outputfile) {
        StreamGobbler.execute(command, null, outputfile, -1);
    }

    public static void execute(String command, String outputfile, int timeoutMilliSeconds) {
        StreamGobbler.execute(command, null, outputfile, timeoutMilliSeconds);
    }

    public static boolean execute(String command, String inputfile, String outputfile, int timeoutMilliSeconds) {
        long startTime = System.currentTimeMillis();
        System.out.println("Start time: " + Calendar.getInstance().getTime());
        System.out.println("Execute command: " + command);
        try {
            int exitVal;
            FileOutputStream fos = new FileOutputStream(outputfile);
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(command);
            if (inputfile != null) {
                try {
                    System.out.println("using command file: " + inputfile);
                    FileInputStream dataFromFile = new FileInputStream(inputfile);
                    OutputStream standardInputOfChildProcess = proc.getOutputStream();
                    byte[] buff = new byte[4096];
                    int count = -1;
                    while ((count = ((InputStream)dataFromFile).read(buff)) != -1) {
                        standardInputOfChildProcess.write(buff, 0, count);
                    }
                    ((InputStream)dataFromFile).close();
                    standardInputOfChildProcess.close();
                }
                catch (Exception e) {
                    String msg = "Error in StreamGobbler: Cannot copy input stream from " + inputfile;
                    System.out.println(msg);
                    throw new RuntimeException(msg);
                }
            }
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), "ERROR");
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), "OUTPUT", fos);
            errorGobbler.start();
            outputGobbler.start();
            boolean result = true;
            if (timeoutMilliSeconds > 0) {
                exitVal = proc.waitFor(timeoutMilliSeconds, TimeUnit.MILLISECONDS) ? 1 : 0;
                if (exitVal == 0) {
                    System.out.println("Process interrupted by timeout " + timeoutMilliSeconds + " milliseconds");
                    proc.destroyForcibly();
                    result = false;
                }
            } else {
                exitVal = proc.waitFor();
                System.out.println("Exit value: " + exitVal);
                if (exitVal != 0) {
                    result = false;
                }
            }
            System.out.println("End time: " + Calendar.getInstance().getTime());
            fos.flush();
            fos.close();
            if (result) {
                System.out.println("Output is redirected to: " + outputfile);
            }
            long executionTime = System.currentTimeMillis() - startTime;
            System.out.println("Execution time: " + executionTime + " msec");
            return result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
    }
}

