/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.linear.impl;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.HashMap;
import javax.constraints.Objective;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.impl.Problem;

public class LinearSolver
extends javax.constraints.linear.LinearSolver {
    public static final String JSR331_LINEAR_SOLVER_VERSION = "SCIP v.3.0.0 with SoPlex 1.7.0";

    public String getCommanLine() {
        String options;
        String exe = System.getProperty(LP_SOLVER_EXE);
        if (exe == null) {
            exe = "scip";
        }
        if ((options = System.getProperty(LP_SOLVER_OPTIONS)) == null) {
            options = "";
        }
        return exe + " -c \"read " + this.getInputFilename() + " " + options + " optimize write solution " + this.getOutputFilename() + " quit\"";
    }

    public String getVersion() {
        return JSR331_LINEAR_SOLVER_VERSION;
    }

    public Objective getDefaultOptimizationObjective() {
        return Objective.MINIMIZE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] readResultValues() {
        BufferedReader reader = null;
        try {
            String line;
            VarReal[] varReals;
            reader = new BufferedReader(new FileReader(this.getOutputFilename()));
            Problem problem = (Problem)this.getProblem();
            for (int i = 0; i < 2; ++i) {
                String line2 = reader.readLine();
                if (line2.indexOf("infeasible") <= 0) continue;
                int[] nArray = null;
                return nArray;
            }
            int n = 0;
            Var[] vars = problem.getVars();
            if (vars != null) {
                n += vars.length;
            }
            if ((varReals = problem.getVarReals()) != null) {
                n += varReals.length;
            }
            int[] values = new int[n];
            for (int i = 0; i < n; ++i) {
                values[i] = 0;
            }
            while ((line = reader.readLine()) != null) {
                String name = line.substring(0, 9);
                String value = line.substring(10, 53);
                int index = this.indexOfVariable(name.trim());
                if (index >= 0) {
                    values[index] = (int)Double.parseDouble(value);
                    continue;
                }
                String msg = "Error in org.jcp.jsr331.linear.scip: Unknown variable " + name + " among resulting values";
                this.log(msg);
                throw new RuntimeException(msg);
            }
            int[] nArray = values;
            return nArray;
        }
        catch (Exception ex) {
            this.log("Error during reading the file " + this.getOutputFilename());
            ex.printStackTrace();
            int[] nArray = null;
            return nArray;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {
                this.log("Error during closing the file " + this.getOutputFilename());
                ex.printStackTrace();
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> readResults() {
        HashMap<String, String> results = new HashMap<String, String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(this.getOutputFilename()));
            Problem problem = (Problem)this.getProblem();
            for (int i = 0; i < 2; ++i) {
                String line2 = reader.readLine();
                if (line2.indexOf("infeasible") <= 0) continue;
                HashMap<String, String> hashMap = null;
                return hashMap;
            }
            while ((line = reader.readLine()) != null) {
                String name = line.substring(0, 9);
                String value = line.substring(10, 53);
                results.put(name.trim(), value.trim());
            }
            HashMap<String, String> hashMap = results;
            return hashMap;
        }
        catch (Exception ex) {
            this.log("Error during reading the file " + this.getOutputFilename());
            ex.printStackTrace();
            HashMap<String, String> hashMap = null;
            return hashMap;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception ex) {
                this.log("Error during closing the file " + this.getOutputFilename());
                ex.printStackTrace();
                return null;
            }
        }
    }
}

