/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.extra;

import java.util.Iterator;
import java.util.Set;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarSet;
import javax.constraints.extra.PropagationEvent;
import javax.constraints.extra.Propagator;
import javax.constraints.impl.AbstractConstraint;
import javax.constraints.impl.AbstractVar;
import javax.constraints.impl.BasicVarSet;

public final class ConstraintElementAtOnSets
extends AbstractConstraint {
    private final VarSet setVar;
    private final Var indexVar;
    private final Set[] sets;
    Propagator indexPropagator;

    public ConstraintElementAtOnSets(VarSet setVar, Set[] sets, Var indexVar) {
        super(indexVar.getProblem(), "ConstraintElementAtOnSets");
        this.setVar = setVar;
        this.indexVar = indexVar;
        this.sets = sets;
        this.indexPropagator = new IndexPropagator();
    }

    @Override
    public void post() {
        ((AbstractVar)this.indexVar).addPropagator(this.indexPropagator, PropagationEvent.VALUE);
        BasicVarSet imp = (BasicVarSet)this.setVar;
        Set valueSet = imp.getValueSet();
        Iterator iter = valueSet.iterator();
        while (iter.hasNext()) {
            int val = (Integer)iter.next();
            try {
                Var vari = imp.getRequiredVar(val);
                VarPropagator varPropagator = new VarPropagator(vari, val);
                ((AbstractVar)vari).addPropagator(varPropagator, PropagationEvent.VALUE);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    final class VarPropagator
    implements Propagator {
        int value;
        Var var;

        public VarPropagator(Var theVar, int theValue) {
            this.var = theVar;
            this.value = theValue;
        }

        @Override
        public void propagate(PropagationEvent event) throws Exception {
            block4: {
                Problem p = ConstraintElementAtOnSets.this.getProblem();
                Integer intValue = new Integer(this.value);
                if (!this.var.isBound()) break block4;
                if (this.var.getMin() == 1) {
                    for (int a = ConstraintElementAtOnSets.this.indexVar.getMin(); a <= ConstraintElementAtOnSets.this.indexVar.getMax(); ++a) {
                        if (ConstraintElementAtOnSets.this.sets[a].contains(intValue)) continue;
                        p.post(ConstraintElementAtOnSets.this.indexVar, "!=", a);
                    }
                } else {
                    for (int a = ConstraintElementAtOnSets.this.indexVar.getMin(); a <= ConstraintElementAtOnSets.this.indexVar.getMax(); ++a) {
                        if (!ConstraintElementAtOnSets.this.sets[a].contains(intValue)) continue;
                        p.post(ConstraintElementAtOnSets.this.indexVar, "!=", a);
                    }
                }
            }
        }
    }

    final class IndexPropagator
    implements Propagator {
        IndexPropagator() {
        }

        @Override
        public void propagate(PropagationEvent event) throws Exception {
            if (ConstraintElementAtOnSets.this.indexVar.isBound()) {
                ConstraintElementAtOnSets.this.setVar.setValue(ConstraintElementAtOnSets.this.sets[ConstraintElementAtOnSets.this.indexVar.getValue()]);
            }
        }
    }
}

