/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.ConsistencyLevel;
import javax.constraints.Constraint;
import javax.constraints.Probability;
import javax.constraints.Problem;
import javax.constraints.VarBool;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.CommonBase;

public abstract class AbstractConstraint
extends CommonBase
implements Constraint {
    public AbstractConstraint(Problem problem) {
        this(problem, "");
    }

    public AbstractConstraint(Problem problem, String name) {
        super(problem, name);
        this.setImpl(null);
    }

    @Override
    public void post() {
        AbstractProblem p = (AbstractProblem)this.getProblem();
        p.post(this);
    }

    @Override
    public void post(ConsistencyLevel consistencyLevel) {
        this.post();
    }

    @Override
    public void post(String name, Probability probability) {
        AbstractProblem p = (AbstractProblem)this.getProblem();
        if (probability.getValue() == Probability.ALWAYS.getValue()) {
            this.post();
            return;
        }
        if (probability.getValue() == Probability.NEVER.getValue()) {
            throw new RuntimeException("Attempt to post a constraint with Probability.NEVER");
        }
        p.addConstraintWithProbability(name, this, probability);
    }

    @Override
    public VarBool asBool() {
        throw new RuntimeException("Constraint " + this.getName() + " has no implementation for the method asBool(). It cannot be used in logical expressions.");
    }

    @Override
    public Constraint and(Constraint c) {
        return this.and(c);
    }

    @Override
    public Constraint or(Constraint c) {
        return this.or(c);
    }

    @Override
    public Constraint negation() {
        return this.implies(this.getProblem().getFalseConstraint());
    }

    @Override
    public Constraint implies(Constraint c) {
        throw new RuntimeException("The Constraint method implies should be overloaded by the RI");
    }
}

