/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.constraints.ConstrainedVariable;
import javax.constraints.Constraint;
import javax.constraints.DomainType;
import javax.constraints.Oper;
import javax.constraints.Probability;
import javax.constraints.Problem;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarBool;
import javax.constraints.VarMatrix;
import javax.constraints.VarReal;
import javax.constraints.VarSet;
import javax.constraints.VarString;
import javax.constraints.extra.Reversible;
import javax.constraints.impl.AbstractVar;
import javax.constraints.impl.BasicVarMatrix;
import javax.constraints.impl.BasicVarSet;
import javax.constraints.impl.BasicVarString;
import javax.constraints.impl.constraint.ConstraintFalse;
import javax.constraints.impl.constraint.ConstraintGlobalCardinality;
import javax.constraints.impl.constraint.ConstraintMax;
import javax.constraints.impl.constraint.ConstraintMin;
import javax.constraints.impl.constraint.ConstraintTrue;

public abstract class AbstractProblem
implements Problem {
    private HashMap<String, Oper> operators;
    String name;
    Object object;
    ArrayList<Var> vars;
    ArrayList<VarReal> varReals;
    ArrayList<VarBool> varBools;
    HashMap<String, Var[]> varArrays;
    ArrayList<Constraint> constraints;
    Solver solver;
    DomainType domainType;
    ArrayList<Var> savedVars;
    ArrayList<VarBool> savedVarBools;
    HashMap<String, Var[]> savedVarArrays;
    ArrayList<Constraint> savedConstraints;
    HashMap<String, VarMatrix> varMatrixs;
    ArrayList<VarString> varStrings;
    ArrayList<Var> constraintViolations;
    protected static double REAL_PRECISION = 1.0E-6;

    @Override
    public String getAPIVersion() {
        return "JSR-331 \"Constraint Programming API\" Release 2.3.1";
    }

    @Override
    public abstract String getImplVersion();

    public AbstractProblem(String name) {
        this.name = name;
        this.log(this.getAPIVersion());
        this.log(this.getImplVersion());
        this.vars = new ArrayList();
        this.varReals = new ArrayList();
        this.varBools = new ArrayList();
        this.constraints = new ArrayList();
        this.varArrays = new HashMap();
        this.varMatrixs = new HashMap();
        this.varStrings = new ArrayList();
        this.constraintViolations = new ArrayList();
        this.solver = null;
        this.operators = new HashMap();
        this.operators.put("=", Oper.EQ);
        this.operators.put("==", Oper.EQ);
        this.operators.put("Is", Oper.EQ);
        this.operators.put("is", Oper.EQ);
        this.operators.put("!=", Oper.NEQ);
        this.operators.put("Is Not", Oper.NEQ);
        this.operators.put("is not", Oper.NEQ);
        this.operators.put("<", Oper.LT);
        this.operators.put("<=", Oper.LE);
        this.operators.put(">", Oper.GT);
        this.operators.put(">=", Oper.GE);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String name) {
        this.name = name;
    }

    public final DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public final void setDomainType(DomainType domainType) {
        this.domainType = domainType;
    }

    @Override
    public Var add(Var var) {
        this.add(var.getName(), var);
        return var;
    }

    @Override
    public VarBool add(VarBool varBool) {
        this.varBools.add(varBool);
        return varBool;
    }

    public void remove(String varName) {
        Var var = this.getVar(varName);
        if (var != null) {
            boolean result = this.vars.remove(var);
            if (!result) {
                result = this.varReals.remove(var);
            }
            if (!result) {
                boolean bl = this.varBools.remove(var);
            }
        }
    }

    @Override
    public Var add(String name, Var var) {
        Var oldVar = this.getVar(name);
        if (oldVar != null) {
            this.vars.remove(oldVar);
        }
        this.vars.add(var);
        var.setName(name);
        return var;
    }

    @Override
    public VarReal add(VarReal var) {
        return this.add(var.getName(), var);
    }

    @Override
    public VarReal add(String name, VarReal var) {
        VarReal oldVar = this.getVarReal(name);
        if (oldVar != null) {
            this.varReals.remove(oldVar);
        }
        this.varReals.add(var);
        var.setName(name);
        return var;
    }

    public Var var(String name, String symbolicExpression) {
        this.error("The implementation does not support symbolic Var expressions like:\n" + symbolicExpression);
        return null;
    }

    @Override
    public Constraint post(String name, String symbolicExpression) {
        this.error("The implementation does not support symbolic constraints like:\n" + symbolicExpression);
        return null;
    }

    @Override
    public Var variable(String name, int min, int max) {
        Var var = this.createVariable(name, min, max);
        this.add(var);
        return var;
    }

    @Override
    public abstract Var createVariable(String var1, int var2, int var3);

    @Override
    public VarReal createVariableReal(String name, double min, double max) {
        this.error("Problem's method createVariableReal(String name, double min, double max) is not implemented");
        return null;
    }

    @Override
    public Var variable(String name, int min, int max, DomainType domainType) {
        DomainType current = this.getDomainType();
        this.setDomainType(domainType);
        Var var = this.variable(name, min, max);
        this.setDomainType(current);
        return var;
    }

    @Override
    public Var variable(int min, int max) {
        Var var = this.variable("noname", min, max);
        this.remove("noname");
        var.setName("");
        return var;
    }

    @Override
    public VarReal variableReal(String name, double min, double max) {
        VarReal var = this.createVariableReal(name, min, max);
        this.add(var);
        return var;
    }

    @Override
    public VarReal variableReal(String name) {
        return this.variableReal(name, 1.0, Double.MAX_VALUE);
    }

    @Override
    public VarSet variableSet(String name, int min, int max) throws Exception {
        BasicVarSet var = new BasicVarSet(this, min, max, name);
        var.setEmpty(false);
        return var;
    }

    @Override
    public VarSet variableSet(String name, int[] values) throws Exception {
        BasicVarSet var = new BasicVarSet((Problem)this, values, name);
        var.setEmpty(false);
        return var;
    }

    @Override
    public VarSet variableSet(String name, Set set) throws Exception {
        BasicVarSet var = new BasicVarSet((Problem)this, set, name);
        var.setEmpty(false);
        return var;
    }

    @Override
    public Var[] variableArray(String name, int min, int max, int size) {
        Var[] array = new Var[size];
        for (int i = 0; i < size; ++i) {
            String iName = name == null || name.isEmpty() ? "" : name + "-" + i;
            array[i] = this.variable(iName, min, max);
        }
        return array;
    }

    public Var[] addVarArray(String name, Var[] vars) {
        this.varArrays.put(name, vars);
        return vars;
    }

    public Var[] addVarArray(String arrayName, String[] varNames) {
        int n = varNames.length;
        Var[] array = new Var[n];
        for (int i = 0; i < n; ++i) {
            array[i] = this.getVar(varNames[i]);
        }
        this.varArrays.put(arrayName, array);
        return array;
    }

    @Override
    public Var variable(String name, int[] domain) {
        int max = -2147483647;
        int min = 0x7FFFFFFE;
        for (int i = 0; i < domain.length; ++i) {
            int v = domain[i];
            if (min > v) {
                min = v;
            }
            if (max >= v) continue;
            max = v;
        }
        Var var = this.variable(name, min, max);
        if (domain.length <= Math.abs(max - min)) {
            int counter = 1;
            AbstractVar abstractVar = (AbstractVar)var;
            for (int i = min + 1; i < max; ++i) {
                if (domain[counter] != i) {
                    try {
                        this.post((Var)abstractVar, "!=", i);
                    }
                    catch (Exception e) {
                        this.log("value " + i + "can not be removed from " + var);
                    }
                    continue;
                }
                ++counter;
            }
        }
        return var;
    }

    @Override
    public Var variable(int[] domain) {
        return this.variable("", domain);
    }

    @Override
    public abstract VarBool variableBool(String var1);

    @Override
    public Var[] getVars() {
        if (this.vars.isEmpty()) {
            return null;
        }
        Var[] array = new Var[this.vars.size()];
        Iterator<Var> iterator = this.vars.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i++] = iterator.next();
        }
        return array;
    }

    public ArrayList<Var> getVarArray() {
        return this.vars;
    }

    public ArrayList<VarReal> getVarRealArray() {
        return this.varReals;
    }

    @Override
    public VarBool[] getVarBools() {
        if (this.varBools.isEmpty()) {
            return null;
        }
        VarBool[] array = new VarBool[this.varBools.size()];
        Iterator<VarBool> iterator = this.varBools.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i++] = iterator.next();
        }
        return array;
    }

    @Override
    public VarBool variableBool() {
        VarBool var = this.variableBool("noname");
        this.remove("noname");
        var.setName("");
        return var;
    }

    @Override
    public VarReal[] getVarReals() {
        if (this.varReals.isEmpty()) {
            return null;
        }
        VarReal[] array = new VarReal[this.varReals.size()];
        Iterator<VarReal> iterator = this.varReals.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i++] = iterator.next();
        }
        return array;
    }

    @Override
    public VarReal[] getVarSets() {
        return null;
    }

    @Override
    public Var getVar(String name) {
        if (name == null) {
            return null;
        }
        for (Var var : this.vars) {
            if (!name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    @Override
    public VarReal getVarReal(String name) {
        if (name == null) {
            return null;
        }
        for (VarReal var : this.varReals) {
            if (!name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    @Override
    public Var[] getVarArray(String name) {
        return this.varArrays.get(name);
    }

    public Var[] varSquare(String name, int min, int max, int size) {
        Var[] array = new Var[size * size];
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                String iName = name == null ? "" : name + "[" + i + "," + j + "]";
                array[i * size + j] = this.variable(iName, min, max);
            }
        }
        if (name != null) {
            this.varArrays.put(name, array);
        }
        return array;
    }

    @Override
    public Constraint add(Constraint constraint) {
        return this.add(constraint.getName(), constraint);
    }

    public Constraint add(String name, Constraint constraint) {
        constraint.setName(name);
        this.constraints.add(constraint);
        return constraint;
    }

    @Override
    public Constraint[] getConstraints() {
        Constraint[] array = new Constraint[this.constraints.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.constraints.get(i);
        }
        return array;
    }

    @Override
    public final Constraint getConstraint(String name) {
        if (this.constraints.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.constraints.size(); ++i) {
            if (!name.endsWith(this.constraints.get(i).getName())) continue;
            return this.constraints.get(i);
        }
        return null;
    }

    protected Oper stringToOper(String oper) {
        Oper op = this.operators.get(oper);
        if (op == null) {
            throw new RuntimeException("Invalid Operator " + oper);
        }
        return op;
    }

    @Override
    public Var element(int[] array, Var indexVar) {
        Var elemVar = this.variable("_element_", array);
        this.postElement(array, indexVar, "=", elemVar);
        return elemVar;
    }

    @Override
    public Var element(Var[] array, Var indexVar) {
        int min = array[0].getMin();
        int max = array[0].getMax();
        for (int i = 1; i < array.length; ++i) {
            Var var = array[i];
            if (min > var.getMin()) {
                min = var.getMin();
            }
            if (max >= var.getMax()) continue;
            max = var.getMax();
        }
        Var elemVar = this.variable("_element_", min, max);
        this.postElement(array, indexVar, "=", elemVar);
        return elemVar;
    }

    @Override
    public Var element(ArrayList<Var> list, Var indexVar) {
        Var[] array = list.toArray(new Var[list.size()]);
        return this.element(array, indexVar);
    }

    @Override
    public VarSet element(Set<Integer>[] sets, Var indexVar) throws Exception {
        this.error("Method element(Set[] sets, Var indexVar) is not implemented");
        return null;
    }

    @Override
    public Constraint postAnd(Constraint c1, Constraint c2) {
        Constraint and = c1.and(c2);
        and.post();
        return and;
    }

    @Override
    public Constraint postOr(Constraint c1, Constraint c2) {
        Constraint or = c1.or(c2);
        or.post();
        return or;
    }

    @Override
    @Deprecated
    public Constraint post(int[] array, Var[] vars, String oper, Var var) {
        Var scalProd = this.scalProd(array, vars);
        return this.post(scalProd, oper, var);
    }

    @Override
    @Deprecated
    public Constraint post(int[] array, Var[] vars, String oper, int value) {
        Var scalProd = this.scalProd(array, vars);
        return this.post(scalProd, oper, value);
    }

    @Override
    @Deprecated
    public Constraint post(Var[] vars, String oper, int value) {
        Var sum = this.sum(vars);
        return this.post(sum, oper, value);
    }

    @Override
    @Deprecated
    public Constraint post(Var[] vars, String oper, Var var) {
        Var sum = this.sum(vars);
        return this.post(sum, oper, var);
    }

    @Override
    @Deprecated
    public Constraint post(Var var1, Var var2, String oper, int value) {
        Var sum = var1.plus(var2);
        return this.post(sum, oper, value);
    }

    @Override
    @Deprecated
    public Constraint post(Var var1, Var var2, String oper, Var var) {
        Var sum = var1.plus(var2);
        return this.post(sum, oper, var);
    }

    @Override
    @Deprecated
    public Constraint post(int[] array, ArrayList<Var> vars, String oper, int value) {
        Var[] varArray = vars.toArray(new Var[vars.size()]);
        return this.post(array, varArray, oper, value);
    }

    @Deprecated
    public Constraint post(int[] array, ArrayList<Var> vars, String oper, Var var) {
        Var[] varArray = vars.toArray(new Var[vars.size()]);
        return this.post(array, varArray, oper, var);
    }

    @Override
    public Constraint post(VarReal var, String oper, int value) {
        this.error("Problem's method post(VarReal var, String oper, int value) is not implemented");
        return null;
    }

    @Override
    public Constraint post(VarReal var, String oper, double value) {
        this.error("Problem's method post(VarReal var, String oper, double value) is not implemented");
        return null;
    }

    @Override
    public Constraint post(VarReal var1, String oper, VarReal var2) {
        this.error("Problem's method post(VarReal var1, String oper, VarReal var2) is not implemented");
        return null;
    }

    @Override
    @Deprecated
    public Constraint post(VarReal[] vars, String oper, double value) {
        double[] array = new double[vars.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = 1.0;
        }
        return this.post(array, vars, oper, value);
    }

    @Override
    @Deprecated
    public Constraint post(VarReal[] vars, String oper, VarReal var) {
        double[] array = new double[vars.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = 1.0;
        }
        return this.post(array, vars, oper, var);
    }

    @Override
    public Constraint post(VarReal var1, String oper, Var var2) {
        this.error("Problem's method post(VarReal var1, String oper, Var var2) is not implemented");
        return null;
    }

    @Deprecated
    public Constraint post(double[] coefficients, Var[] vars, String oper, double value) {
        this.error("Problem's method post(double[] array, Var[] vars, String oper, double value) is not implemented");
        return null;
    }

    @Override
    @Deprecated
    public Constraint post(double[] array, VarReal[] vars, String oper, VarReal var) {
        this.error("Problem's method post(double[] array, VarReal[] vars, String oper, VarReal var) is not implemented");
        return null;
    }

    @Override
    @Deprecated
    public Constraint post(double[] array, VarReal[] vars, String oper, double value) {
        this.error("Problem's method post(double[] array, VarReal[] vars, String oper, double value) is not implemented");
        return null;
    }

    @Override
    @Deprecated
    public Constraint post(double[] array, ConstrainedVariable[] vars, String oper, ConstrainedVariable var) {
        this.error("Problem's method post(double[] array, ConstrainedVariable[] vars, String oper, VarReal var) is not implemented");
        return null;
    }

    @Override
    @Deprecated
    public Constraint post(double[] array, ConstrainedVariable[] vars, String oper, double value) {
        this.error("Problem's method post(double[] array, ConstrainedVariable[] vars, String oper, double value) is not implemented");
        return null;
    }

    @Override
    public Constraint post(Var var1, String oper, VarReal var2) {
        this.error("Problem's method post(Var var1, String oper, VarReal var2) is not implemented");
        return null;
    }

    @Override
    public Constraint postAllDiff(Var[] vars) {
        return this.postAllDifferent(vars);
    }

    @Override
    public Constraint postAllDifferent(ArrayList<Var> vars) {
        Var[] array = new Var[vars.size()];
        int i = 0;
        for (Var var : vars) {
            array[i++] = var;
        }
        return this.postAllDifferent(array);
    }

    @Override
    public Constraint postAllDiff(ArrayList<Var> vars) {
        return this.postAllDifferent(vars);
    }

    public Constraint postAllDifferent(List vars) {
        Var[] array = new Var[vars.size()];
        int i = 0;
        for (Object var : vars) {
            array[i++] = (Var)var;
        }
        return this.postAllDifferent(array);
    }

    @Override
    public Constraint allDiff(ArrayList<Var> vars) {
        return this.postAllDifferent(vars);
    }

    @Override
    public Constraint postAllDifferent(Var[] vars) {
        Constraint c = this.allDiff(vars);
        c.post();
        return c;
    }

    @Override
    public Constraint postAllDiff(VarString[] varStrings) {
        Var[] vars = new Var[varStrings.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = varStrings[i].getInt();
        }
        return this.postAllDiff(vars);
    }

    @Override
    public Constraint isOneOfConstraint(int[] array, Var var) {
        Var sum;
        if (array.length == 1) {
            sum = this.linear(var, "=", array[0]).asBool();
        } else {
            Var[] bools = new VarBool[array.length];
            for (int i = 0; i < array.length; ++i) {
                bools[i] = this.linear(var, "=", array[i]).asBool();
            }
            sum = this.sum(bools);
        }
        return this.linear(sum, ">=", 1);
    }

    @Override
    public Constraint isOneOfConstraint(String[] array, VarString var) {
        Var sum;
        if (array.length == 1) {
            sum = this.linear(var, "=", array[0]).asBool();
        } else {
            Var[] bools = new VarBool[array.length];
            for (int i = 0; i < array.length; ++i) {
                bools[i] = this.linear(var, "=", array[i]).asBool();
            }
            sum = this.sum(bools);
        }
        return this.linear(sum, ">=", 1);
    }

    @Override
    public Constraint isNotOneOfConstraint(int[] array, Var var) {
        Var sum;
        if (array.length == 1) {
            sum = this.linear(var, "=", array[0]).asBool();
        } else {
            Var[] bools = new VarBool[array.length];
            for (int i = 0; i < array.length; ++i) {
                bools[i] = this.linear(var, "=", array[i]).asBool();
            }
            sum = this.sum(bools);
        }
        return this.linear(sum, "=", 0);
    }

    @Override
    public Constraint isNotOneOfConstraint(String[] array, VarString var) {
        Var sum;
        if (array.length == 1) {
            sum = this.linear(var, "=", array[0]).asBool();
        } else {
            Var[] bools = new VarBool[array.length];
            for (int i = 0; i < array.length; ++i) {
                bools[i] = this.linear(var, "=", array[i]).asBool();
            }
            sum = this.sum(bools);
        }
        return this.linear(sum, "=", 0);
    }

    @Override
    public abstract void post(Constraint var1);

    public Constraint and(Constraint[] array) {
        Constraint result = array[0];
        for (int i = 1; i < array.length; ++i) {
            result = result.and(array[i]);
        }
        return result;
    }

    @Override
    public Constraint postIfThen(Constraint constraint1, Constraint constraint2) {
        Constraint implies = constraint1.implies(constraint2);
        implies.post();
        return implies;
    }

    @Override
    public Constraint postIfThen(VarBool var1, VarBool var2) {
        Constraint c1 = this.linear((Var)var1, "=", 1);
        Constraint c2 = this.linear((Var)var2, "=", 1);
        return this.postIfThen(c1, c2);
    }

    @Override
    public Solver getSolver() {
        if (!this.isSolverCreated()) {
            this.solver = this.createSolver();
        }
        return this.solver;
    }

    @Override
    public void setSolver(Solver solver) {
        this.solver = solver;
    }

    public boolean isSolverCreated() {
        return this.solver != null;
    }

    protected abstract Solver createSolver();

    public void log(String text, Var[] vars) {
        if (text != null) {
            this.log(text);
        }
        this.log(vars);
    }

    @Override
    public void log(Var[] vars) {
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                Var var = vars[i];
                this.log("Var[" + i + "]: " + var.toString());
            }
        }
    }

    @Override
    public void log(ArrayList<Var> vars) {
        if (vars != null) {
            for (int i = 0; i < vars.size(); ++i) {
                Var var = vars.get(i);
                this.log("ArrayList<Var>(" + i + "): " + var.toString());
            }
        }
    }

    public void log(String text, VarReal[] vars) {
        if (text != null) {
            this.log(text);
        }
        this.log(vars);
    }

    @Override
    public void log(VarReal[] vars) {
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                VarReal var = vars[i];
                this.log("VarReal[" + i + "]: " + var.toString());
            }
        }
    }

    public void log(String text, VarSet[] vars) {
    }

    public void log(VarSet[] vars) {
    }

    public void log(Constraint[] constraints) {
        if (constraints != null) {
            for (int i = 0; i < constraints.length; ++i) {
                Constraint ct = constraints[i];
                this.log("Constraint[" + i + "]: " + ct.getName());
            }
        }
    }

    @Override
    public abstract void log(String var1);

    public abstract void debug(String var1);

    public abstract void error(String var1);

    @Override
    public Constraint postCardinality(Var[] vars, Var cardVar, String oper, Var var) {
        Var[] boolVars = new VarBool[vars.length];
        for (int i = 0; i < boolVars.length; ++i) {
            boolVars[i] = this.linear(vars[i], "=", cardVar).asBool();
        }
        return this.post(boolVars, oper, var);
    }

    @Override
    public Constraint postCardinality(Var[] vars, Var cardVar, String oper, int value) {
        Var[] boolVars = new VarBool[vars.length];
        for (int i = 0; i < boolVars.length; ++i) {
            boolVars[i] = this.linear(vars[i], "=", cardVar).asBool();
        }
        return this.post(boolVars, oper, value);
    }

    @Override
    public Constraint postCardinality(ArrayList<Var> vars, int cardValue, String oper, int value) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.postCardinality(array, cardValue, oper, value);
    }

    @Override
    public Constraint postCardinality(ArrayList<Var> vars, int cardValue, String oper, Var var) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.postCardinality(array, cardValue, oper, var);
    }

    @Override
    public Constraint postCardinality(ArrayList<Var> vars, Var cardVar, String oper, int value) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.postCardinality(array, cardVar, oper, value);
    }

    @Override
    public Constraint postCardinality(ArrayList<Var> vars, Var cardVar, String oper, Var var) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.postCardinality(array, cardVar, oper, var);
    }

    @Override
    public Constraint postGlobalCardinality(Var[] vars, int[] values, Var[] cardinalityVars) {
        ConstraintGlobalCardinality c = new ConstraintGlobalCardinality(vars, values, cardinalityVars);
        c.post();
        return c;
    }

    @Override
    public Constraint postGlobalCardinality(ArrayList<Var> vars, int[] values, Var[] cardinalityVars) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.postGlobalCardinality(array, values, cardinalityVars);
    }

    @Override
    public Constraint postGlobalCardinality(Var[] vars, int[] values, int[] cardMin, int[] cardMax) {
        int min = cardMin[0];
        int max = cardMax[0];
        for (int i = 0; i < cardMin.length; ++i) {
            if (cardMin[i] > cardMax[i]) {
                throw new RuntimeException("GlobalCardinality error: cardMin[" + i + "] <= cardMax[" + i + "]");
            }
            if (cardMin[i] < min) {
                min = cardMin[i];
            }
            if (cardMax[i] <= max) continue;
            max = cardMax[i];
        }
        Var[] cardinalityVars = this.variableArray(this.name, min, max, values.length);
        Constraint c = this.postGlobalCardinality(vars, values, cardinalityVars);
        for (int i = 0; i < cardinalityVars.length; ++i) {
            this.post(cardinalityVars[i], ">=", cardMin[i]);
            this.post(cardinalityVars[i], "<=", cardMax[i]);
        }
        return c;
    }

    @Override
    public Constraint postGlobalCardinality(ArrayList<Var> vars, int[] values, int[] cardMin, int[] cardMax) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.postGlobalCardinality(array, values, cardMin, cardMax);
    }

    @Override
    public Constraint postMax(Var[] vars, String oper, Var var) {
        ConstraintMax c = new ConstraintMax(vars, oper, var);
        c.post();
        return c;
    }

    @Override
    public Constraint postMax(Var[] vars, String oper, int value) {
        ConstraintMax c = new ConstraintMax(vars, oper, value);
        c.post();
        return c;
    }

    @Override
    public Constraint postMin(Var[] vars, String oper, Var var) {
        ConstraintMin c = new ConstraintMin(vars, oper, var);
        c.post();
        return c;
    }

    @Override
    public Constraint postMin(Var[] vars, String oper, int value) {
        ConstraintMin c = new ConstraintMin(vars, oper, value);
        c.post();
        return c;
    }

    @Override
    public Var min(Var[] vars) {
        int m = vars[0].getMin();
        int M = vars[0].getMax();
        for (int i = 1; i < vars.length; ++i) {
            Var var = vars[i];
            int mini = var.getMin();
            int maxi = var.getMax();
            if (m > mini) {
                m = mini;
            }
            if (M <= maxi) continue;
            M = maxi;
        }
        Var minVar = this.createVariable("_min_", m, M);
        Var[] equalities = new Var[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            Var var = vars[i];
            this.post(minVar, "<=", var);
            equalities[i] = this.linear(minVar, "=", vars[i]).asBool();
        }
        this.post(equalities, ">=", 1);
        return minVar;
    }

    @Override
    public Var max(Var[] vars) {
        int m = vars[0].getMin();
        int M = vars[0].getMax();
        for (int i = 1; i < vars.length; ++i) {
            Var var = vars[i];
            int mini = var.getMin();
            int maxi = var.getMax();
            if (m < mini) {
                m = mini;
            }
            if (M >= maxi) continue;
            M = maxi;
        }
        Var maxVar = this.createVariable("_max_", m, M);
        Var[] equalities = new Var[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            Var var = vars[i];
            this.post(maxVar, ">=", var);
            equalities[i] = this.linear(maxVar, "=", vars[i]).asBool();
        }
        this.post(equalities, ">=", 1);
        return maxVar;
    }

    @Override
    public Var max(ArrayList<Var> vars) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.max(array);
    }

    @Override
    public Var min(ArrayList<Var> vars) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.min(array);
    }

    @Override
    public Var min(Var var1, Var var2) {
        try {
            int minVal = var1.getMin() < var2.getMin() ? var1.getMin() : var2.getMin();
            int maxVal = var1.getMax() < var2.getMax() ? var1.getMax() : var2.getMax();
            Var min = this.variable("_min_", minVal, maxVal);
            this.remove("_min_");
            this.post(min, "<=", var1);
            this.post(min, "<=", var2);
            VarBool eq1 = this.linear(min, "=", var1).asBool();
            VarBool eq2 = this.linear(min, "=", var2).asBool();
            this.post(eq1.plus(eq2), "!=", 0).post();
            return min;
        }
        catch (Exception e) {
            this.log("Failure to create min(var1,var2)");
            return null;
        }
    }

    @Override
    public Var max(Var var1, Var var2) {
        try {
            int minVal = var1.getMin() > var2.getMin() ? var1.getMin() : var2.getMin();
            int maxVal = var1.getMax() > var2.getMax() ? var1.getMax() : var2.getMax();
            Var max = this.variable("_max_", minVal, maxVal);
            this.remove("_max_");
            this.post(max, ">=", var1);
            this.post(max, ">=", var2);
            VarBool eq1 = this.linear(max, "=", var1).asBool();
            VarBool eq2 = this.linear(max, "=", var2).asBool();
            this.post(eq1.plus(eq2), "!=", 0).post();
            return max;
        }
        catch (Exception e) {
            this.log("Failure to create max(var1,var2)");
            return null;
        }
    }

    @Override
    public Var sum(Var[] vars) {
        if (vars.length == 0) {
            this.log("Attempt to find a sum of an empty array");
            return this.variable(0, 0);
        }
        int min = 0;
        int max = 0;
        for (int i = 0; i < vars.length; ++i) {
            min += vars[i].getMin();
            max += vars[i].getMax();
        }
        AbstractProblem p = (AbstractProblem)vars[0].getProblem();
        Var sumVar = p.variable("_sum_", min, max);
        p.post(vars, "=", sumVar);
        p.remove("_sum_");
        return sumVar;
    }

    @Override
    public Var sum(String name, Var[] vars) {
        if (vars.length == 0) {
            this.log("Attempt to find a sum of an empty array");
            return this.variable(0, 0);
        }
        int min = 0;
        int max = 0;
        for (int i = 0; i < vars.length; ++i) {
            min += vars[i].getMin();
            max += vars[i].getMax();
        }
        AbstractProblem p = (AbstractProblem)vars[0].getProblem();
        Var sumVar = p.variable(name, min, max);
        p.post(vars, "=", sumVar);
        return sumVar;
    }

    @Override
    public Var sum(Var var1, Var var2) {
        return this.sum(new Var[]{var1, var2});
    }

    @Override
    public Var sum(Var var1, Var var2, Var var3) {
        return this.sum(new Var[]{var1, var2, var3});
    }

    @Override
    public Var sum(ArrayList<Var> vars) {
        if (vars.size() == 0) {
            this.log("Attempt to find a sum of an empty array");
            return this.variable(0, 0);
        }
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.sum(array);
    }

    @Override
    public VarReal sum(VarReal[] vars) {
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < vars.length; ++i) {
            min += vars[i].getMin();
            max += vars[i].getMax();
        }
        AbstractProblem p = (AbstractProblem)vars[0].getProblem();
        VarReal sumVar = p.variableReal("_sum_", min, max);
        p.remove("_sum_");
        p.post(vars, "=", sumVar);
        return sumVar;
    }

    @Override
    public VarReal sum(VarReal var1, VarReal var2) {
        return this.sum(new VarReal[]{var1, var2});
    }

    @Override
    public VarReal sum(VarReal var1, VarReal var2, VarReal var3) {
        return this.sum(new VarReal[]{var1, var2, var3});
    }

    @Override
    public void setRealPrecision(double value) {
        REAL_PRECISION = value;
    }

    @Override
    public double getRealPrecision() {
        return REAL_PRECISION;
    }

    public Reversible addReversible(String name, int value) {
        throw new RuntimeException("This RI does not support Reversible integers");
    }

    @Override
    public Constraint postElement(Set[] arrayOfSets, Var indexVar, String oper, VarSet var) {
        this.notImplementedException("Constraint postElement is not implemented on Sets");
        return null;
    }

    @Override
    public Constraint getFalseConstraint() {
        return new ConstraintFalse(this);
    }

    @Override
    public Constraint getTrueConstraint() {
        return new ConstraintTrue(this);
    }

    public void notImplementedException(String feature) {
        String msg = feature + " is not implemented by " + this.getImplVersion();
        this.log(msg);
        throw new RuntimeException(msg);
    }

    @Override
    public void add(VarString var) {
        this.varStrings.add(var);
    }

    @Override
    public VarString[] getVarStrings() {
        if (this.varStrings.isEmpty()) {
            return null;
        }
        VarString[] array = new VarString[this.varStrings.size()];
        Iterator<VarString> iterator = this.varStrings.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            array[i++] = iterator.next();
        }
        return array;
    }

    @Override
    public VarString getVarString(String name) {
        if (this.varStrings.isEmpty()) {
            return null;
        }
        Iterator<VarString> iterator = this.varStrings.iterator();
        boolean i = false;
        while (iterator.hasNext()) {
            VarString var = iterator.next();
            if (!name.equals(var.getName())) continue;
            return var;
        }
        return null;
    }

    @Override
    public VarString variableString(String name, String[] allStrings) {
        BasicVarString varString = new BasicVarString(this, name, allStrings);
        this.add(varString);
        return varString;
    }

    @Override
    public Constraint post(VarString var, String oper, String value) {
        int index = var.getIndex(value);
        if (index < 0) {
            throw new RuntimeException("ERROR: " + var.getName() + " " + oper + " " + value + ": value " + value + " is expected to be inside variable domain " + var.getInitialDomain());
        }
        return this.post(var.getInt(), oper, index);
    }

    @Override
    public Constraint linear(VarString var, String oper, String value) {
        int index = var.getIndex(value);
        if (index < 0) {
            throw new RuntimeException("ERROR: " + var.getName() + " " + oper + " " + value + ": value " + value + " is expected to be inside variable domain " + var.getInitialDomain());
        }
        return this.linear(var.getInt(), oper, index);
    }

    @Override
    public Constraint linear(VarString var1, String oper, VarString var2) {
        return this.linear(var1.getInt(), oper, var2.getInt());
    }

    @Override
    public Constraint post(VarString var1, String oper, VarString var2) {
        return this.post(var1.getInt(), oper, var2.getInt());
    }

    @Override
    public Constraint post(ArrayList<Var> vars, String oper, int value) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.post(array, oper, value);
    }

    @Override
    public Constraint post(ArrayList<Var> vars, String oper, Var var) {
        Var[] array = vars.toArray(new Var[vars.size()]);
        return this.post(array, oper, var);
    }

    @Override
    public Constraint postScalProd(Var var, String oper, int[] arrayOfValues, Var[] arrayOfVariables) {
        return this.post(var, oper, this.scalProd(arrayOfValues, arrayOfVariables));
    }

    @Override
    public Var scalProd(int[] arrayOfValues, ArrayList<Var> vars) {
        Var[] arrayOfVariables = vars.toArray(new Var[vars.size()]);
        return this.scalProd(arrayOfValues, arrayOfVariables);
    }

    @Override
    public Var scalProd(String name, int[] arrayOfValues, Var[] arrayOfVariables) {
        Var scalProd = this.scalProd(arrayOfValues, arrayOfVariables);
        this.add(name, scalProd);
        return scalProd;
    }

    @Override
    public VarReal scalProd(double[] arrayOfValues, VarReal[] arrayOfVariables) {
        this.error("Problem's method scalProd(double[] arrayOfValues, VarReal[] arrayOfVariables) is not implemented");
        return null;
    }

    @Override
    public VarReal scalProd(double[] arrayOfValues, ConstrainedVariable[] arrayOfVariables) {
        this.error("Problem's method scalProd(double[] arrayOfValues, ConstrainedVariable[] arrayOfVariables) is not implemented");
        return null;
    }

    @Override
    public VarMatrix variableMatrix(String name, int min, int max, int rows, int columns) {
        BasicVarMatrix matrix = new BasicVarMatrix(this, name, min, max, rows, columns);
        this.varMatrixs.put(name, matrix);
        return matrix;
    }

    @Override
    public VarMatrix getVarMatrix(String name) {
        return this.varMatrixs.get(name);
    }

    public void addConstraintWithProbability(String name, Constraint c, Probability probability) {
        int weight = probability.getValue();
        VarBool constraintVar = c.asBool();
        VarBool violation = this.variableBool(name);
        Constraint zero = this.linear((Var)constraintVar, "=", 0);
        Constraint one = this.linear((Var)constraintVar, "=", 1);
        Constraint violationZero = this.linear((Var)violation, "=", 0);
        Constraint violationOne = this.linear((Var)violation, "=", 1);
        this.postIfThen(zero, violationOne);
        this.postIfThen(one, violationZero);
        this.constraintViolations.add(violation.multiply(weight));
    }

    @Override
    public Var getTotalConstraintViolation() {
        if (!this.areThereProbabilityConstraints()) {
            this.log("There are no constraint postings with probabilities");
            return this.variable("stub for TotalConstraintViolation", 0, 0);
        }
        Var sum = this.sum(this.constraintViolations);
        sum.setName("TotalConstraintViolation");
        return sum;
    }

    @Override
    public boolean areThereProbabilityConstraints() {
        return this.constraintViolations.size() > 0;
    }
}

