/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.DomainType;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.extra.PropagationEvent;
import javax.constraints.extra.Propagator;
import javax.constraints.impl.AbstractConstrainedVariable;

public abstract class AbstractVar
extends AbstractConstrainedVariable
implements Var {
    DomainType domainType;

    public AbstractVar(Problem problem) {
        super(problem);
    }

    public AbstractVar(Problem problem, String name) {
        super(problem, name);
    }

    @Override
    public DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public void setDomainType(DomainType type) {
        if (this.domainType == type) {
            return;
        }
    }

    @Override
    public int getValue() {
        if (!this.isBound()) {
            throw new RuntimeException("Attempt to getValue of non instantiated Var variable " + this.getName());
        }
        return this.getMin();
    }

    @Override
    public String getInitialDomain() {
        return "[" + this.getMin() + ";" + this.getMax() + "]";
    }

    @Override
    public int getDomainSize() {
        return this.getMax() - this.getMin() + 1;
    }

    @Override
    public Var minus(int value) {
        return this.plus(-value);
    }

    @Override
    public Var minus(Var var) {
        return this.plus(var.multiply(-1));
    }

    @Override
    public Var divide(int value) {
        if (value == 0) {
            throw new RuntimeException("Attemt to use Var.div(0)");
        }
        if (value == 1) {
            return this;
        }
        if (value == -1) {
            return this.negative();
        }
        int min = this.getMin() * value;
        int max = this.getMax() * value;
        if (value < 0) {
            max = min = max;
        }
        Var result = this.getProblem().variable("", min, max);
        this.getProblem().post((Var)this, "=", result.multiply(value));
        return result;
    }

    @Override
    public Var divide(Var var) throws Exception {
        if (var.isBound() && var.getValue() == 0) {
            throw new Exception("Divisor " + var + "is instantiated by 0");
        }
        Var result = this.getProblem().variable("", -2147483647, 0x7FFFFFFE);
        this.getProblem().post((Var)this, "=", result.multiply(var));
        return result;
    }

    @Override
    public Var mod(int value) {
        Var quotient = this.divide(value);
        return this.minus(quotient.multiply(value));
    }

    public String toString() {
        if (this.getMin() == this.getMax()) {
            return this.getName() + "[" + this.getMin() + "]";
        }
        return this.getName() + "[" + this.getMin() + ".." + this.getMax() + "]";
    }

    @Override
    public Var negative() {
        return this.multiply(-1);
    }

    @Override
    public Var sqr() {
        return this.multiply(this);
    }

    @Override
    public Var power(int value) {
        Var var = this;
        for (int i = 1; i < value; ++i) {
            var = var.multiply(this);
        }
        return var;
    }

    @Override
    public VarReal asReal() {
        throw new RuntimeException("There is no implementation for the method asReal()");
    }

    public void addPropagator(Propagator propagator, PropagationEvent event) {
        throw new RuntimeException("There is no implementation for the Var method addPropagator");
    }

    public int compareTo(Var var) {
        throw new RuntimeException("The Java method compareTo should not be used for constrained variables");
    }

    @Override
    public boolean contains(int value) {
        throw new RuntimeException("There is no implementation for the Var method contains(int value)");
    }

    @Override
    public Var plus(int value) {
        throw new RuntimeException("There is no implementation for the Var method plus(int value)");
    }

    @Override
    public Var plus(Var var) {
        throw new RuntimeException("There is no implementation for the Var method plus(Var var)");
    }

    @Override
    public Var multiply(int value) {
        throw new RuntimeException("There is no implementation for the Var method multiply(int value)");
    }

    @Override
    public Var multiply(Var var) {
        throw new RuntimeException("There is no implementation for the Var method multiply(Var var)");
    }

    @Override
    public Var percent(int percent) {
        return this.multiply(percent).divide(100);
    }

    @Override
    public Var abs() {
        throw new RuntimeException("There is no implementation for the Var method abs()");
    }
}

