/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.extra.PropagationEvent;
import javax.constraints.extra.Propagator;
import javax.constraints.impl.AbstractConstrainedVariable;

public abstract class AbstractVarReal
extends AbstractConstrainedVariable
implements VarReal {
    public AbstractVarReal(Problem problem) {
        super(problem);
    }

    public AbstractVarReal(Problem problem, String name) {
        super(problem, name);
    }

    @Override
    public double getValue() {
        if (!this.isBound()) {
            throw new RuntimeException("Attempt to getValue of non instantiated VarReal variable " + this.getName());
        }
        return this.getMin();
    }

    @Override
    public String getInitialDomain() {
        return "[" + this.getMin() + ";" + this.getMax() + "]";
    }

    @Override
    public VarReal minus(double value) {
        return this.plus(-value);
    }

    @Override
    public VarReal minus(int value) {
        return this.plus(-value);
    }

    @Override
    public VarReal minus(Var var) {
        return this.plus(var.multiply(-1));
    }

    @Override
    public VarReal divide(double value) {
        if (value == 0.0) {
            throw new RuntimeException("Attemt to use Var.div(0)");
        }
        if (value == 1.0) {
            return this;
        }
        if (value == -1.0) {
            return this.negative();
        }
        double min = this.getMin() * value;
        double max = this.getMax() * value;
        if (value < 0.0) {
            max = min = max;
        }
        VarReal result = this.getProblem().variableReal("", min, max);
        this.getProblem().post((VarReal)this, "=", result.multiply(value));
        return result;
    }

    @Override
    public VarReal divide(int value) {
        return this.divide((double)value);
    }

    @Override
    public VarReal divide(VarReal var) throws Exception {
        if (var.isBound() && var.getValue() == 0.0) {
            throw new Exception("Divisor " + var + "is instantiated by 0");
        }
        VarReal result = this.getProblem().variableReal("", Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        this.getProblem().post((VarReal)this, "=", result.multiply(var));
        return result;
    }

    public VarReal mod(int value) {
        VarReal quotient = this.divide(value);
        return this.minus(quotient.multiply(value));
    }

    public String toString() {
        if (this.isBound()) {
            return this.getName() + "[" + this.getMin() + "]";
        }
        return this.getName() + "[" + this.getMin() + " .. " + this.getMax() + "]";
    }

    @Override
    public VarReal negative() {
        return this.multiply(-1);
    }

    @Override
    public VarReal sqr() {
        return this.multiply(this);
    }

    @Override
    public VarReal power(int value) {
        VarReal var = this;
        for (int i = 1; i < value; ++i) {
            var = var.multiply(this);
        }
        return var;
    }

    public void addPropagator(Propagator propagator, PropagationEvent event) {
        throw new RuntimeException("There is no implementation for the VarReal method addPropagator");
    }

    public int compareTo(VarReal var) {
        throw new RuntimeException("The Java method compareTo should not be used for constrained variables");
    }

    public boolean contains(double value) {
        return value >= this.getMin() && value <= this.getMax();
    }

    @Override
    public VarReal plus(int value) {
        return this.plus((double)value);
    }

    @Override
    public VarReal plus(VarReal var) {
        throw new RuntimeException("There is no implementation for the VarReal method plus(VarReal var)");
    }

    @Override
    public VarReal plus(double value) {
        throw new RuntimeException("There is no implementation for the VarReal method plus(double value)");
    }

    @Override
    public VarReal plus(Var var) {
        throw new RuntimeException("There is no implementation for the VarReal method plus(Var var)");
    }

    @Override
    public VarReal multiply(double value) {
        throw new RuntimeException("There is no implementation for the VarReal method multiply(int value)");
    }

    @Override
    public VarReal multiply(int value) {
        return this.multiply((double)value);
    }

    @Override
    public VarReal multiply(Var var) {
        throw new RuntimeException("There is no implementation for the VarReal method multiply(Var var)");
    }

    @Override
    public VarReal multiply(VarReal var) {
        throw new RuntimeException("There is no implementation for the VarReal method multiply(VarReal var)");
    }

    @Override
    public VarReal abs() {
        throw new RuntimeException("There is no implementation for the VarReal method abs()");
    }

    @Override
    public void removeRange(double min, double max) throws Exception {
        throw new RuntimeException("There is no implementation for the VarReal method removeRange(double min, double max)");
    }

    @Override
    public VarReal minus(VarReal var) {
        throw new RuntimeException("There is no implementation for the VarReal method minus(VarReal var)");
    }

    @Override
    public VarReal divide(Var var) throws Exception {
        throw new RuntimeException("There is no implementation for the VarReal method divide(Var var)");
    }

    @Override
    public VarReal power(double value) {
        throw new RuntimeException("There is no implementation for the VarReal method power(double value)");
    }
}

