/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarMatrix;

public class BasicVarMatrix
implements VarMatrix {
    Problem problem;
    String name;
    int rows;
    int columns;
    int min;
    int max;
    Var[][] matrix;
    Var[] rowVars;
    Var[] columnVars;

    public BasicVarMatrix(Problem problem, String name, int min, int max, int rows, int columns) {
        this.problem = problem;
        this.name = name;
        this.min = min;
        this.max = max;
        this.rows = rows;
        this.columns = columns;
        this.matrix = new Var[rows][columns];
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                String varName = name + i + j;
                this.matrix[i][j] = problem.variable(varName, min, max);
            }
        }
    }

    @Override
    public int numberOfRows() {
        return this.rows;
    }

    @Override
    public int numberOfColumns() {
        return this.columns;
    }

    @Override
    public Var[] row(int i) {
        Var[] rowi = new Var[this.columns];
        for (int j = 0; j < this.columns; ++j) {
            rowi[j] = this.matrix[i][j];
        }
        return rowi;
    }

    @Override
    public Var[] column(int j) {
        Var[] columnj = new Var[this.rows];
        for (int i = 0; i < this.rows; ++i) {
            columnj[i] = this.matrix[i][j];
        }
        return columnj;
    }

    @Override
    public Var[] flat() {
        Var[] array = new Var[this.rows * this.columns];
        int k = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                array[k++] = this.matrix[i][j];
            }
        }
        return array;
    }

    @Override
    public Var[] diagonal1() {
        if (this.rows != this.columns) {
            return null;
        }
        Var[] diag = new Var[this.rows];
        int k = 0;
        for (int i = 0; i < this.rows; ++i) {
            diag[k++] = this.matrix[i][i];
        }
        return diag;
    }

    @Override
    public Var[] diagonal2() {
        if (this.rows != this.columns) {
            return null;
        }
        Var[] diag = new Var[this.rows];
        int k = 0;
        for (int i = 0; i < this.rows; ++i) {
            diag[k++] = this.matrix[i][this.rows - i - 1];
        }
        return diag;
    }

    @Override
    public Var get(int i, int j) {
        return this.matrix[i][j];
    }

    @Override
    public void post(int[][] data) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                this.problem.post(this.matrix[i][j], "=", data[i][j]);
            }
        }
    }

    @Override
    public void post(int i, int j, int value) {
        this.problem.post(this.matrix[i][j], "=", value);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                Var var = this.matrix[i][j];
                if (var.isBound()) {
                    int value = var.getValue();
                    String gap = " ";
                    if (value < 10) {
                        gap = "  ";
                    }
                    buf.append(gap + value);
                    continue;
                }
                buf.append(" " + var.toString());
            }
            buf.append("\n");
        }
        return buf.toString();
    }
}

