/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.constraints.Constraint;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarSet;
import javax.constraints.impl.AbstractConstrainedVariable;
import javax.constraints.impl.constraint.ConstraintTrue;

public class BasicVarSet
extends AbstractConstrainedVariable
implements VarSet {
    Set valueSet;
    Var[] requiredVars;
    ValueVarMap valueVarMap;
    Var cardinality;

    public BasicVarSet(Problem problem, int[] values, String name) throws Exception {
        super(problem, name);
        this.valueSet = new HashSet();
        for (int i = 0; i < values.length; ++i) {
            this.valueSet.add(new Integer(values[i]));
        }
        this.init();
    }

    public BasicVarSet(Problem problem, int min, int max, String name) throws Exception {
        this(problem, new int[max - min + 1], name);
    }

    public BasicVarSet(Problem problem, Set set, String name) throws Exception {
        super(problem, name);
        this.valueSet = set;
        this.init();
    }

    public void init() throws Exception {
        this.requiredVars = new Var[this.valueSet.size()];
        this.valueVarMap = new ValueVarMap();
        Iterator iter = this.valueSet.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Integer valueObj = (Integer)iter.next();
            int value = valueObj;
            this.requiredVars[i] = this.problem.variable(this.name + "(" + value + ")", 0, 1);
            this.valueVarMap.put(valueObj, this.requiredVars[i]);
            ++i;
        }
        this.cardinality = this.problem.variable("", 0, this.requiredVars.length);
        this.problem.postCardinality(this.requiredVars, 1, "=", this.cardinality);
    }

    public Var[] getRequiredVars() {
        return this.requiredVars;
    }

    @Override
    public void setEmpty(boolean flag) {
        if (flag) {
            this.getProblem().post(this.cardinality, "=", 0);
        } else {
            this.getProblem().post(this.cardinality, ">=", 1);
        }
    }

    @Override
    public boolean isBound() {
        for (int i = 0; i < this.requiredVars.length; ++i) {
            if (this.requiredVars[i].isBound()) continue;
            return false;
        }
        return true;
    }

    public Set getValue() throws Exception {
        if (!this.isBound()) {
            throw new Exception("Attempt to get value of the unbound set variable " + this.getName());
        }
        return this.getRequiredSet();
    }

    public void setValue(Set set) throws Exception {
        for (Integer valueObj : set) {
            int value = valueObj;
            this.require(value);
        }
        this.valueVarMap.removeNotRequiredValues();
    }

    public Set getRequiredSet() {
        return this.valueVarMap.getRequiredSet();
    }

    public Set getPossibleSet() {
        return this.valueVarMap.getPossibleSet();
    }

    @Override
    public boolean isPossible(int value) {
        Var var = this.valueVarMap.get(value);
        if (var == null) {
            return false;
        }
        return var.getMax() != 0;
    }

    @Override
    public boolean isRequired(int value) {
        Var var = this.valueVarMap.get(value);
        if (var == null) {
            return false;
        }
        return var.getMax() == 1;
    }

    public Var getRequiredVar(int value) throws Exception {
        Var var = this.valueVarMap.get(value);
        if (var == null) {
            throw new Exception("Value " + value + " is not in domain of " + this.getName());
        }
        return var;
    }

    @Override
    public void remove(int value) throws Exception {
        Var var = this.getRequiredVar(value);
        this.getProblem().post(var, "=", 0);
    }

    @Override
    public void require(int value) throws Exception {
        Var var = this.getRequiredVar(value);
        this.getProblem().post(var, "=", 1);
    }

    public boolean contains(Set setOfValues) {
        if (!this.valueSet.containsAll(setOfValues)) {
            return false;
        }
        Iterator iter = setOfValues.iterator();
        while (iter.hasNext()) {
            int value = (Integer)iter.next();
            if (this.isPossible(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Var getCardinality() {
        return this.cardinality;
    }

    public Constraint doNotIntersectWith(VarSet varSet) throws Exception {
        VarSet intersection = this.intersection(varSet);
        if (intersection == null) {
            return new ConstraintTrue(this.getProblem());
        }
        return this.getProblem().post(intersection.getCardinality(), "=", 0);
    }

    public Set getValueSet() {
        return this.valueSet;
    }

    @Override
    public VarSet intersection(VarSet varSet) throws Exception {
        Set values1 = this.getValueSet();
        Set values2 = ((BasicVarSet)varSet).getValueSet();
        int[] commonValues = new int[values1.size()];
        Iterator iter = values1.iterator();
        int numberOfCommonValues = 0;
        while (iter.hasNext()) {
            Integer currentValue = (Integer)iter.next();
            if (!values2.contains(currentValue)) continue;
            commonValues[numberOfCommonValues++] = currentValue;
        }
        if (numberOfCommonValues == 0) {
            return null;
        }
        int[] intersection = new int[numberOfCommonValues];
        System.arraycopy(commonValues, 0, intersection, 0, numberOfCommonValues);
        Problem p = this.getProblem();
        String name = this.getName() + "&" + varSet.getName();
        BasicVarSet intersectionVarSet = new BasicVarSet(p, intersection, name);
        for (int i = 0; i < intersection.length; ++i) {
            int value = intersection[i];
            Var var1 = this.getRequiredVar(value);
            Var var2 = ((BasicVarSet)varSet).getRequiredVar(value);
            Var var3 = intersectionVarSet.getRequiredVar(value);
            Constraint c11 = p.linear(var1, "=", 1);
            Constraint c21 = p.linear(var2, "=", 1);
            Constraint c31 = p.linear(var3, "=", 1);
            p.postIfThen(c11.and(c21), c31);
            Constraint c10 = p.linear(var1, "=", 0);
            Constraint c20 = p.linear(var2, "=", 0);
            Constraint c30 = p.linear(var3, "=", 0);
            p.postIfThen(c10.or(c20), c30);
        }
        return intersectionVarSet;
    }

    @Override
    public VarSet union(VarSet varSet) {
        this.getProblem().log("==== union is not implemented");
        return null;
    }

    public String toString() {
        return "VarSet " + this.getName() + this.cardinality + ":" + this.valueVarMap.toString();
    }

    class ValueVarMap {
        HashMap map = new HashMap();

        ValueVarMap() {
        }

        void put(int value, Var var) {
            this.map.put(new Integer(value), var);
        }

        void put(Integer value, Var var) {
            this.map.put(value, var);
        }

        Var get(int value) {
            return (Var)this.map.get(new Integer(value));
        }

        Var get(Integer value) {
            return (Var)this.map.get(value);
        }

        public Set getRequiredSet() {
            HashSet requiredSet = new HashSet();
            Set entries = this.map.entrySet();
            for (Map.Entry entry : entries) {
                Var var = (Var)entry.getValue();
                if (var.getMin() != 1) continue;
                requiredSet.add(entry.getKey());
            }
            return requiredSet;
        }

        public void removeNotRequiredValues() throws Exception {
            Set entries = this.map.entrySet();
            for (Map.Entry entry : entries) {
                Var var = (Var)entry.getValue();
                if (var.getMin() == 1) continue;
                BasicVarSet.this.getProblem().post(var, "=", 0);
            }
        }

        public Set getPossibleSet() {
            HashSet possibleSet = new HashSet();
            Set entries = this.map.entrySet();
            for (Map.Entry entry : entries) {
                Var var = (Var)entry.getValue();
                if (var.getMax() != 1) continue;
                possibleSet.add(entry.getKey());
            }
            return possibleSet;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            Set entries = this.map.entrySet();
            for (Map.Entry entry : entries) {
                Var var = (Var)entry.getValue();
                if (var.getMin() == 1) {
                    buf.append(" [" + entry.getKey() + "]");
                    continue;
                }
                buf.append(" " + entry.getKey());
            }
            return buf.toString();
        }
    }
}

