/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.DomainType;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarString;
import javax.constraints.impl.AbstractConstrainedVariable;

public class BasicVarString
extends AbstractConstrainedVariable
implements VarString {
    String[] allStrings = null;
    Var myvar;

    public BasicVarString(Problem problem, String[] allStrings) {
        this(problem, "", allStrings);
    }

    public BasicVarString(Problem problem, String name, String[] allStrings) {
        super(problem, name);
        this.allStrings = allStrings;
        this.myvar = problem.variable(name, 0, allStrings.length - 1, DomainType.DOMAIN_SMALL);
        this.myvar.setObject(this);
    }

    @Override
    public String[] getAllStrings() {
        return this.allStrings;
    }

    @Override
    public Var getInt() {
        return this.myvar;
    }

    @Override
    public String getValue() {
        return this.allStrings[this.myvar.getValue()];
    }

    @Override
    public String getValue(int index) {
        return this.allStrings[index];
    }

    @Override
    public String getInitialDomain() {
        if (this.allStrings == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.allStrings.length; ++i) {
            if (i > 0) {
                buf.append(" ");
            }
            buf.append(this.allStrings[i]);
        }
        return buf.toString();
    }

    @Override
    public boolean isBound() {
        return this.myvar.isBound();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName() + "[");
        int n = 0;
        for (int i = 0; i < this.allStrings.length; ++i) {
            if (!this.myvar.contains(i)) continue;
            if (n > 0) {
                buf.append(",");
            }
            buf.append(this.allStrings[i]);
            ++n;
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean hasSameDomain(VarString var) {
        if (this.allStrings.length == var.getAllStrings().length) {
            for (int i = 0; i < this.allStrings.length; ++i) {
                if (this.allStrings[i].equals(var.getAllStrings()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int getIndex(String string) {
        for (int i = 0; i < this.allStrings.length; ++i) {
            if (!this.allStrings[i].equals(string)) continue;
            return i;
        }
        return -1;
    }
}

