/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl;

import javax.constraints.Problem;

public final class Real {
    public static boolean eq(Problem p, double d1, double d2) {
        return Math.abs(d1 - d2) < p.getRealPrecision();
    }

    public static boolean gt(Problem p, double d1, double d2) {
        return d1 - d2 > p.getRealPrecision();
    }

    public static boolean ge(Problem p, double d1, double d2) {
        return d1 - d2 > -p.getRealPrecision();
    }

    public static boolean isNan(double v) {
        return Double.isNaN(v);
    }

    public static boolean isInf(double v) {
        return Double.isInfinite(v);
    }

    public static double inverseMin(double min, double max) {
        Real.assertMinMax(min, max);
        double _min = min > 0.0 || max < 0.0 ? 1.0 / max : (min == 0.0 && max > 0.0 ? 1.0 / max : (max == 0.0 && min < 0.0 ? Double.NEGATIVE_INFINITY : Double.NEGATIVE_INFINITY));
        return _min;
    }

    public static double inverseMax(double min, double max) {
        Real.assertMinMax(min, max);
        double _max = min > 0.0 || max < 0.0 ? 1.0 / min : (min == 0.0 && max > 0.0 ? Double.POSITIVE_INFINITY : (max == 0.0 && min < 0.0 ? 1.0 / min : Double.POSITIVE_INFINITY));
        return _max;
    }

    public static double inverseMin(double v) {
        return v != 0.0 ? 1.0 / v : Double.NEGATIVE_INFINITY;
    }

    public static double inverseMax(double v) {
        return v != 0.0 ? 1.0 / v : Double.POSITIVE_INFINITY;
    }

    public static double log(double x, double base) {
        return Math.log(x) / Math.log(base);
    }

    public static double pow(double y, double v) {
        double x = Math.pow(y, 1.0 / v);
        return x;
    }

    public static double productMinP(double min1, double max1, double min2) {
        if (min2 >= 0.0) {
            return min1 * min2;
        }
        return max1 * min2;
    }

    public static double productMaxP(double min1, double max1, double max2) {
        if (max2 >= 0.0) {
            return max1 * max2;
        }
        return min1 * max2;
    }

    public static double productMinN(double min1, double max1, double max2) {
        if (max2 >= 0.0) {
            return min1 * max2;
        }
        return max1 * max2;
    }

    public static double productMaxN(double min1, double max1, double min2) {
        if (min2 >= 0.0) {
            return max1 * min2;
        }
        return min1 * min2;
    }

    public static double productMin(double min1, double max1, double min2, double max2) {
        if (min1 >= 0.0) {
            return Real.productMinP(min1, max1, min2);
        }
        if (max1 <= 0.0) {
            return Real.productMinN(min1, max1, max2);
        }
        if (min2 >= 0.0) {
            return min1 * max2;
        }
        if (max2 <= 0.0) {
            return max1 * min2;
        }
        return Math.min(max1 * min2, min1 * max2);
    }

    public static double productMax(double min1, double max1, double min2, double max2) {
        if (min1 >= 0.0) {
            return Real.productMaxP(min1, max1, max2);
        }
        if (max1 <= 0.0) {
            return Real.productMaxN(min1, max1, min2);
        }
        if (min2 >= 0.0) {
            return max1 * max2;
        }
        if (max2 <= 0.0) {
            return min1 * min2;
        }
        return Math.max(min1 * min2, max1 * max2);
    }

    public static double sqrMax(double min, double max) {
        return Math.max(min * min, max * max);
    }

    public static double sqrMin(double min, double max) {
        if (min >= 0.0) {
            return min * min;
        }
        if (max >= 0.0) {
            return 0.0;
        }
        return max * max;
    }

    public static void doAssert(boolean v, String s) {
        if (v) {
            return;
        }
        System.out.println("Assertion failed: " + s);
    }

    public static void assertMinMax(double min, double max) {
        Real.doAssert(!Real.isNan(min), "min not NaN");
        Real.doAssert(!Real.isNan(max), "max not NaN");
        Real.doAssert(min <= max, "min <= max");
    }
}

