/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.constraint;

import javax.constraints.Var;
import javax.constraints.impl.AbstractConstraint;
import javax.constraints.impl.AbstractProblem;

public class ConstraintMax
extends AbstractConstraint {
    String oper;
    Var[] vars;
    Var var;
    int value;
    Var maxVar;

    public ConstraintMax(Var[] vars, String oper, Var var) {
        super(vars[0].getProblem());
        this.vars = vars;
        this.oper = oper;
        this.var = var;
        this.createMaxVar();
    }

    public ConstraintMax(Var[] vars, String oper, int value) {
        super(vars[0].getProblem());
        this.vars = vars;
        this.oper = oper;
        this.var = null;
        this.value = value;
        this.createMaxVar();
    }

    void createMaxVar() {
        AbstractProblem p = (AbstractProblem)this.getProblem();
        int min = this.vars[0].getMin();
        int max = this.vars[0].getMax();
        for (int i = 1; i < this.vars.length; ++i) {
            int mini = this.vars[i].getMin();
            int maxi = this.vars[i].getMax();
            if (min < mini) {
                min = mini;
            }
            if (max >= maxi) continue;
            max = maxi;
        }
        this.maxVar = p.variable("MaxArray", min, max);
        Var[] equalities = new Var[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            p.post(this.maxVar, ">=", this.vars[i]);
            equalities[i] = p.linear(this.maxVar, "=", this.vars[i]).asBool();
        }
        p.post(equalities, ">=", 1);
    }

    @Override
    public void post() {
        if (this.var == null) {
            this.getProblem().post(this.maxVar, this.oper, this.value);
        } else {
            this.getProblem().post(this.maxVar, this.oper, this.var);
        }
    }

    public Var getMaxVar() {
        return this.maxVar;
    }
}

