/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.constraint;

import javax.constraints.Constraint;
import javax.constraints.Problem;
import javax.constraints.Var;
import javax.constraints.VarBool;
import javax.constraints.impl.AbstractConstraint;

public class ConstraintNotAllEqual
extends AbstractConstraint {
    Constraint constraint;

    public ConstraintNotAllEqual(Var[] vars) {
        super(vars[0].getProblem());
        int n = vars.length - 1;
        Var[] equalities = new VarBool[n];
        Problem p = this.getProblem();
        for (int i = 0; i < n; ++i) {
            equalities[i] = p.linear(vars[i], "=", vars[i + 1]).asBool();
        }
        this.constraint = p.post(equalities, "<", n);
    }

    public ConstraintNotAllEqual(Var[] vars, int[] values) {
        super(vars[0].getProblem());
        if (values.length != vars.length) {
            throw new RuntimeException("ConstraintNotAllEqual(Var[] vars, int[] values) requires arrays of the same length");
        }
        int n = vars.length;
        Var[] equalities = new VarBool[n];
        Problem p = this.getProblem();
        for (int i = 0; i < n; ++i) {
            equalities[i] = p.linear(vars[i], "=", values[i]).asBool();
        }
        this.constraint = this.getProblem().post(equalities, "<", n);
    }

    @Override
    public void post() {
        this.constraint.post();
    }
}

