/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.ArrayList;
import java.util.Vector;
import javax.constraints.SearchStrategy;
import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.ValueSelectorType;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.VarSelector;
import javax.constraints.VarSelectorType;
import javax.constraints.VarSet;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.BasicVarSet;
import javax.constraints.impl.CommonBase;
import javax.constraints.impl.search.selectors.ValueSelectorMax;
import javax.constraints.impl.search.selectors.ValueSelectorMin;
import javax.constraints.impl.search.selectors.ValueSelectorMinMaxAlternate;
import javax.constraints.impl.search.selectors.VarSelectorInputOrder;
import javax.constraints.impl.search.selectors.VarSelectorMinDomain;
import javax.constraints.impl.search.selectors.VarSelectorMinDomainMinValue;
import javax.constraints.impl.search.selectors.VarSelectorRandom;

public abstract class AbstractSearchStrategy
extends CommonBase
implements SearchStrategy {
    Solver solver;
    protected Var[] vars;
    protected VarReal[] varReals;
    protected VarSelector varSelector;
    protected ValueSelector valueSelector;
    SearchStrategy.SearchStrategyType type;

    public AbstractSearchStrategy(Solver solver) {
        super(solver.getProblem());
        this.solver = solver;
        this.varSelector = null;
        this.valueSelector = new ValueSelectorMin();
        this.type = SearchStrategy.SearchStrategyType.DEFAULT;
        this.vars = this.getProblem().getVars();
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public SearchStrategy.SearchStrategyType getType() {
        return this.type;
    }

    @Override
    public void setType(SearchStrategy.SearchStrategyType type) {
        this.type = type;
    }

    @Override
    public Var[] getVars() {
        return this.vars;
    }

    @Override
    public void setVars(Var[] vars) {
        this.vars = vars;
    }

    @Override
    public void setVars(ArrayList<Var> vars) {
        this.setVars(vars.toArray(new Var[vars.size()]));
    }

    @Override
    public void setVars(VarSet[] setVars) {
        Vector<Var> intVars = new Vector<Var>();
        for (int i = 0; i < setVars.length; ++i) {
            BasicVarSet setVar = (BasicVarSet)setVars[i];
            Var[] requiredVars = setVar.getRequiredVars();
            for (int j = 0; j < requiredVars.length; ++j) {
                intVars.add(requiredVars[j]);
            }
            intVars.add(setVar.getCardinality());
        }
        Var[] searchVars = new Var[intVars.size()];
        for (int i = 0; i < intVars.size(); ++i) {
            searchVars[i] = (Var)intVars.elementAt(i);
        }
        this.setVars(searchVars);
    }

    @Override
    public ValueSelector getValueSelector() {
        return this.valueSelector;
    }

    @Override
    public VarSelector getVarSelector() {
        return this.varSelector;
    }

    @Override
    public void setValueSelector(ValueSelector valueSelector) {
        this.valueSelector = valueSelector;
    }

    @Override
    public void setVarSelector(VarSelector varSelector) {
        this.varSelector = varSelector;
    }

    @Override
    public void setVarSelectorType(VarSelectorType varSelectorType) {
        switch (varSelectorType) {
            case INPUT_ORDER: {
                this.setVarSelector(new VarSelectorInputOrder(this));
                break;
            }
            case MIN_DOMAIN: {
                this.setVarSelector(new VarSelectorMinDomain(this));
                break;
            }
            case MIN_DOMAIN_MIN_VALUE: {
                this.setVarSelector(new VarSelectorMinDomainMinValue(this));
                break;
            }
            case RANDOM: {
                this.setVarSelector(new VarSelectorRandom(this));
                break;
            }
            default: {
                this.setVarSelector(new VarSelectorInputOrder(this));
            }
        }
    }

    @Override
    public void setValueSelectorType(ValueSelectorType valueSelectorType) {
        switch (valueSelectorType) {
            case MAX: {
                this.setValueSelector(new ValueSelectorMax());
                break;
            }
            case MIN: {
                this.setValueSelector(new ValueSelectorMin());
                break;
            }
            case MIN_MAX_ALTERNATE: {
                this.setValueSelector(new ValueSelectorMinMaxAlternate());
                break;
            }
            default: {
                this.setValueSelector(new ValueSelectorMin());
            }
        }
    }

    @Override
    public void trace() {
        AbstractProblem p = (AbstractProblem)this.getProblem();
        p.notImplementedException("SearchStrategy method trace()");
    }

    @Override
    public VarReal[] getVarReals() {
        return this.varReals;
    }

    @Override
    public void setVarReals(VarReal[] varReals) {
        this.varReals = varReals;
    }

    @Override
    public boolean run() {
        this.getProblem().log("This method is used only by CUSTOM strategies in which it is overridden");
        return true;
    }
}

