/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Vector;
import javax.constraints.Objective;
import javax.constraints.OptimizationStrategy;
import javax.constraints.Problem;
import javax.constraints.ProblemState;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.SolutionIterator;
import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.ValueSelectorType;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.VarSelector;
import javax.constraints.VarSelectorType;
import javax.constraints.extra.ReversibleAction;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.search.BasicSolutionIterator;
import javax.constraints.impl.search.StrategyLog;
import javax.constraints.impl.search.StrategyLogVariables;

public abstract class AbstractSolver
implements Solver {
    public static int UNLIMITED = 0;
    Problem problem;
    protected Vector<SearchStrategy> searchStrategies;
    Vector<Solution> solutions;
    int maxNumberOfSolutions;
    int timeLimit;
    long timeLimitStart;
    boolean timeLimitExceeded;
    int globalTimeLimit;
    long startTime = System.currentTimeMillis();
    int tolerance;
    long solverStartTime;
    boolean traceExecution;
    boolean traceSolutions;
    OptimizationStrategy optimizationStrategy;
    ArrayList<String> explanations;

    @Override
    public Problem getProblem() {
        return this.problem;
    }

    @Override
    public void setProblem(Problem problem) {
        this.problem = problem;
    }

    public AbstractSolver() {
        this(null);
    }

    public AbstractSolver(Problem problem) {
        this.problem = (AbstractProblem)problem;
        if (problem != null) {
            problem.setSolver(this);
        }
        this.searchStrategies = new Vector();
        this.solverStartTime = System.currentTimeMillis();
        this.optimizationStrategy = OptimizationStrategy.BASIC;
        this.maxNumberOfSolutions = -1;
        this.timeLimit = UNLIMITED;
        this.globalTimeLimit = UNLIMITED;
        this.setTimeLimitStart();
        this.setTimeLimitExceeded(false);
        this.tolerance = 0;
        this.clearSolutions();
        this.traceExecution(false);
        this.traceSolutions(false);
        this.explanations = new ArrayList();
    }

    @Override
    public void saveProblem() {
    }

    @Override
    public void restoreProblem() {
    }

    public Vector<SearchStrategy> getSearchStrategies() {
        if (this.searchStrategies.isEmpty()) {
            SearchStrategy strategy = this.getSearchStrategy();
            this.searchStrategies.add(strategy);
        }
        return this.searchStrategies;
    }

    @Override
    public int getNumberOfSolutions() {
        return this.solutions.size();
    }

    @Override
    public int getMaxNumberOfSolutions() {
        return this.maxNumberOfSolutions;
    }

    @Override
    public void setMaxNumberOfSolutions(int maxNumberOfSolutions) {
        this.maxNumberOfSolutions = maxNumberOfSolutions;
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(int mills) {
        this.timeLimit = mills;
    }

    public boolean checkTimeLimit() {
        if (this.getTimeLimit() <= UNLIMITED) {
            return false;
        }
        long currTime = System.currentTimeMillis();
        return currTime - this.getTimeLimitStart() > (long)this.getTimeLimit();
    }

    @Override
    public int getTimeLimitGlobal() {
        return this.globalTimeLimit;
    }

    @Override
    public void setTimeLimitGlobal(int mills) {
        this.globalTimeLimit = mills;
        if (this.timeLimit == UNLIMITED) {
            this.setTimeLimit(mills);
        }
    }

    public boolean isTimeLimitExceeded() {
        return this.timeLimitExceeded;
    }

    public void setTimeLimitExceeded(boolean exceeded) {
        this.timeLimitExceeded = exceeded;
    }

    @Override
    public long getTimeLimitStart() {
        return this.timeLimitStart;
    }

    @Override
    public void setTimeLimitStart() {
        this.timeLimitStart = System.currentTimeMillis();
        this.timeLimitExceeded = false;
    }

    public void clearSolutions() {
        this.solutions = new Vector();
    }

    public void addSolution(Solution solution) {
        this.solutions.add(solution);
    }

    public Solution[] getSolutions() {
        if (this.solutions == null || this.solutions.size() == 0) {
            return null;
        }
        Solution[] array = new Solution[this.solutions.size()];
        for (int i = 0; i < this.solutions.size(); ++i) {
            array[i] = this.solutions.elementAt(i);
        }
        return array;
    }

    @Override
    public Solution getSolution(int i) {
        if (this.solutions == null || this.solutions.size() == 0 || i < 0 || i >= this.solutions.size()) {
            return null;
        }
        return this.solutions.get(i);
    }

    public Solution getSolution() {
        return this.getSolution(0);
    }

    @Override
    public void setSearchStrategy(SearchStrategy strategy) {
        this.searchStrategies.clear();
        this.searchStrategies.add(strategy);
    }

    @Override
    public SearchStrategy getSearchStrategy() {
        if (this.searchStrategies.isEmpty()) {
            this.setSearchStrategy(this.newSearchStrategy());
        }
        return this.searchStrategies.firstElement();
    }

    @Override
    public SearchStrategy getStrategyLogVariables() {
        return new StrategyLogVariables(this);
    }

    @Override
    public void addStrategyLogVariables() {
        this.addSearchStrategy(this.getStrategyLogVariables());
    }

    public SearchStrategy getLogStrategy(String text) {
        return new StrategyLog(this, text);
    }

    @Override
    public void addLogStrategy(String text) {
        this.addSearchStrategy(this.getLogStrategy(text));
    }

    @Override
    public void setSearchStrategy(Var[] vars, VarSelector varSelector, ValueSelector valueSelector) {
        SearchStrategy strategy = this.getSearchStrategy();
        strategy.setVars(vars);
        strategy.setVarSelector(varSelector);
        strategy.setValueSelector(valueSelector);
        this.setSearchStrategy(strategy);
    }

    @Override
    public void setSearchStrategy(Var[] vars, VarSelector varSelector) {
        SearchStrategy strategy = this.getSearchStrategy();
        strategy.setVars(vars);
        strategy.setVarSelector(varSelector);
        this.setSearchStrategy(strategy);
    }

    @Override
    public void setSearchStrategy(Var[] vars, ValueSelector valueSelector) {
        SearchStrategy strategy = this.getSearchStrategy();
        strategy.setVars(vars);
        strategy.setValueSelector(valueSelector);
        this.setSearchStrategy(strategy);
    }

    @Override
    public void setSearchStrategy(Var[] vars) {
        SearchStrategy strategy = this.getSearchStrategy();
        strategy.setVars(vars);
        this.setSearchStrategy(strategy);
    }

    @Override
    public abstract SearchStrategy newSearchStrategy();

    @Override
    public void addSearchStrategy(SearchStrategy strategy) {
        this.getSearchStrategy();
        this.searchStrategies.add(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars, VarSelector varSelector, ValueSelector valueSelector) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        strategy.setVarSelector(varSelector);
        strategy.setValueSelector(valueSelector);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars, VarSelectorType varSelectorType, ValueSelectorType valueSelectorType) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        strategy.setVarSelectorType(varSelectorType);
        strategy.setValueSelectorType(valueSelectorType);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars, VarSelector varSelector) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        strategy.setVarSelector(varSelector);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars, VarSelectorType varSelectorType) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        strategy.setVarSelectorType(varSelectorType);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars, ValueSelector valueSelector) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        strategy.setValueSelector(valueSelector);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars, ValueSelectorType valueSelectorType) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        strategy.setValueSelectorType(valueSelectorType);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var[] vars) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setVars(vars);
        this.addSearchStrategy(strategy);
    }

    @Override
    public void addSearchStrategy(Var var) {
        Var[] vars = new Var[]{var};
        this.addSearchStrategy(vars);
    }

    public void addSearchStrategy(VarReal var) {
        SearchStrategy strategy = this.getSearchStrategy();
        VarReal[] vars = new VarReal[]{var};
        strategy.setVarReals(vars);
        this.addSearchStrategy(strategy);
    }

    public void addSearchStrategy(ValueSelector valueSelector) {
        SearchStrategy strategy = this.newSearchStrategy();
        strategy.setValueSelector(valueSelector);
        this.addSearchStrategy(strategy);
    }

    @Override
    public SolutionIterator solutionIterator() {
        return new BasicSolutionIterator(this);
    }

    @Override
    public OptimizationStrategy getOptimizationStrategy() {
        return this.optimizationStrategy;
    }

    @Override
    public void setOptimizationStrategy(OptimizationStrategy optimizationStrategy) {
        this.optimizationStrategy = optimizationStrategy;
    }

    @Override
    public void setOptimizationStrategy(String optimizationStrategyName) {
        switch (optimizationStrategyName.toUpperCase()) {
            case "BASIC": {
                this.setOptimizationStrategy(OptimizationStrategy.BASIC);
                break;
            }
            case "DICHOTOMIZE": {
                this.setOptimizationStrategy(OptimizationStrategy.DICHOTOMIZE);
                break;
            }
            default: {
                this.log("Unknown OptimizationStrategy '" + optimizationStrategyName + "'. Use OptimizationStrategy.BASIC");
                this.setOptimizationStrategy(OptimizationStrategy.BASIC);
            }
        }
    }

    @Override
    public void logOptimizationStrategy() {
        this.log("OptimizationStrategy: " + this.optimizationStrategy.name());
    }

    @Override
    public abstract Solution findSolution(ProblemState var1);

    @Override
    public Solution findSolution() {
        return this.findSolution(ProblemState.DO_NOT_RESTORE);
    }

    @Override
    public Solution findOptimalSolution(Objective objective, Var objectiveVar) {
        return this.findOptimalSolutionBasic(objective, objectiveVar);
    }

    @Override
    public Solution findOptimalSolution(Objective objective, VarReal objectiveVar) {
        throw new RuntimeException("There is no implementation for findOptimalSolutionBasic(Objective objective, VarReal objectiveVar)");
    }

    @Override
    public Solution findOptimalSolution(Var objectiveVar) {
        return this.findOptimalSolution(Objective.MINIMIZE, objectiveVar);
    }

    @Override
    public Solution findOptimalSolution(VarReal objectiveVar) {
        return this.findOptimalSolution(Objective.MINIMIZE, objectiveVar);
    }

    public Solution findOptimalSolutionBasic(Objective objective, Var objectiveVar) {
        this.addObjective(objectiveVar);
        long startTime = System.currentTimeMillis();
        if (objectiveVar.getName().isEmpty()) {
            objectiveVar.setName("Objective");
        }
        if (this.getProblem().getVar(objectiveVar.getName()) == null) {
            this.getProblem().add(objectiveVar);
        }
        Var obj = objectiveVar;
        if (objective.equals((Object)Objective.MAXIMIZE)) {
            obj = objectiveVar.multiply(-1);
            obj.setName("-" + objectiveVar.getName());
            this.getProblem().add(obj);
        }
        this.addObjective(obj);
        int bestValue = Integer.MAX_VALUE;
        Solution solution = null;
        int n = 0;
        SolutionIterator iter = this.solutionIterator();
        while (iter.hasNext()) {
            solution = iter.next();
            int newValue = solution.getValue(obj.getName());
            if (this.isTraceSolutions()) {
                this.log("Found a solution #" + solution.getSolutionNumber() + " with objective " + newValue + ". " + Calendar.getInstance().getTime());
            }
            if (this.getMaxNumberOfSolutions() > 0 && ++n == this.getMaxNumberOfSolutions()) {
                this.log("The search is interrupted: MaxNumberOfSolutions " + n + " has been reached.");
                break;
            }
            if (this.getTimeLimitGlobal() > 0 && System.currentTimeMillis() - startTime > (long)this.getTimeLimitGlobal()) {
                this.log("Global time limit " + this.getTimeLimitGlobal() + " mills has been exceeded.");
                break;
            }
            try {
                if (this.isTraceExecution()) {
                    solution.log();
                }
                if (bestValue > newValue) {
                    bestValue = newValue;
                }
                this.getProblem().post(obj, "<", newValue);
            }
            catch (Exception e) {
                break;
            }
        }
        if (solution != null) {
            this.log("Optimal solution is found. Objective: " + solution.getValue(objectiveVar.getName()));
        }
        return solution;
    }

    public Solution findOptimalSolutionDichotomize(Var objectiveVar) {
        return this.findOptimalSolutionDichotomize(Objective.MINIMIZE, objectiveVar);
    }

    public Solution findOptimalSolutionDichotomize(Objective objective, Var objectiveVar) {
        this.log("The method 'findOptimalSolutionDichotomize' should be implemented by a solver implementation.");
        this.log("The default method 'findOptimalSolutionBasic' has been used.");
        return this.findOptimalSolutionBasic(objective, objectiveVar);
    }

    @Override
    public int getOptimizationTolerance() {
        return this.tolerance;
    }

    @Override
    public void setOptimizationTolerance(int tolerance) {
        this.tolerance = tolerance;
    }

    protected void addObjective(Var objectiveVar) {
        for (int i = 0; i < this.searchStrategies.size(); ++i) {
            SearchStrategy strategy = this.searchStrategies.elementAt(i);
            Var[] vars = strategy.getVars();
            for (int j = 0; j < vars.length; ++j) {
                if (vars[j] != objectiveVar) continue;
                return;
            }
        }
        this.addSearchStrategy(objectiveVar);
    }

    protected void addObjective(VarReal objectiveVar) {
        for (int i = 0; i < this.searchStrategies.size(); ++i) {
            SearchStrategy strategy = this.searchStrategies.elementAt(i);
            VarReal[] vars = strategy.getVarReals();
            for (int j = 0; j < vars.length; ++j) {
                if (vars[j] != objectiveVar) continue;
                return;
            }
        }
        this.addSearchStrategy(objectiveVar);
    }

    @Override
    public Solution[] findAllSolutions() {
        SolutionIterator iter = this.solutionIterator();
        long startTime = System.currentTimeMillis();
        ArrayList<Solution> solutions = new ArrayList<Solution>();
        int n = 0;
        while (iter.hasNext()) {
            Solution solution = iter.next();
            solutions.add(solution);
            if (this.getTimeLimit() > 0 && System.currentTimeMillis() - startTime > (long)this.getTimeLimit()) {
                this.log("Reached TimeLimit=" + this.getTimeLimit() + " mills");
                break;
            }
            if (this.getMaxNumberOfSolutions() <= 0 || ++n != this.getMaxNumberOfSolutions()) continue;
            this.log("Found MaxNumberOfSolutions=" + this.getMaxNumberOfSolutions());
            break;
        }
        Solution[] array = new Solution[solutions.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Solution)solutions.get(i);
        }
        return array;
    }

    public abstract boolean applySolution(Solution var1);

    public boolean applySolution(int solutionNumber) {
        Solution solution = this.getSolutions()[solutionNumber];
        return this.applySolution(solution);
    }

    public boolean isTraceExecution() {
        return this.traceExecution;
    }

    public boolean isTraceSolutions() {
        return this.traceSolutions;
    }

    @Override
    public void traceFailures(boolean flag) {
        this.log("Solver method traceFailures() is not implemented");
    }

    public long getSolverStartTime() {
        return this.solverStartTime;
    }

    public void setSolverStartTime(long solverStartTime) {
        this.solverStartTime = solverStartTime;
    }

    @Override
    public void traceExecution(boolean flag) {
        this.traceExecution = flag;
    }

    @Override
    public void traceSolutions(boolean trueOrFalse) {
        this.traceSolutions = trueOrFalse;
    }

    @Override
    public void logStats() {
        this.log("*** Execution Profile ***");
        long executionTime = System.currentTimeMillis() - this.solverStartTime;
        this.log("Execution time: " + executionTime + " msec");
    }

    public void log(String text) {
        this.problem.log(text);
    }

    @Override
    public void addExplanation(String explanation) {
        this.explanations.add(explanation);
    }

    @Override
    public ArrayList<String> getExplanations() {
        return this.explanations;
    }

    public void addReversibleAction(ReversibleAction action) {
        throw new RuntimeException("This RI does not implement Revesible Actions");
    }
}

