/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.Set;
import java.util.Vector;
import javax.constraints.Problem;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarReal;
import javax.constraints.VarString;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.search.AbstractSolver;

public class BasicSolution
implements Solution {
    Solver solver;
    int solutionNumber;
    Var[] vars;
    ResultInt[] intResults;
    ResultReal[] realResults;
    ResultSet[] setResults;
    static int varPerLine = 9;

    public BasicSolution(Solver solver, int solutionNumber) {
        this.solver = solver;
        this.solutionNumber = solutionNumber;
        Vector<SearchStrategy> searchStrategies = ((AbstractSolver)solver).getSearchStrategies();
        Vector<Var> allvars = new Vector<Var>();
        for (SearchStrategy strategy : searchStrategies) {
            Var[] strategyVars;
            for (Var var : strategyVars = strategy.getVars()) {
                if (allvars.contains(var)) continue;
                allvars.add(var);
            }
        }
        this.vars = new Var[allvars.size()];
        this.intResults = new ResultInt[this.vars.length];
        for (int i = 0; i < this.vars.length; ++i) {
            Var var;
            this.vars[i] = var = (Var)allvars.get(i);
            this.intResults[i] = this.createResult(var);
        }
    }

    @Override
    public Solver getSolver() {
        return this.solver;
    }

    @Override
    public Problem getProblem() {
        return this.solver.getProblem();
    }

    public Var[] getVars() {
        return this.vars;
    }

    @Override
    public int getSolutionNumber() {
        return this.solutionNumber;
    }

    @Override
    public void setSolutionNumber(int number) {
        this.solutionNumber = number;
    }

    @Override
    public int getNumberOfVars() {
        if (this.intResults != null) {
            return this.intResults.length;
        }
        return 0;
    }

    @Override
    public int getNumberOfVarReals() {
        if (this.realResults != null) {
            return this.realResults.length;
        }
        return 0;
    }

    @Override
    public int getNumberOfVarSets() {
        if (this.setResults != null) {
            return this.setResults.length;
        }
        return 0;
    }

    @Override
    public int getValue(String name) {
        int i = this.getIndexOfInt(name);
        if (this.intResults[i].bound) {
            return this.intResults[i].value;
        }
        throw new RuntimeException("variable " + name + " is not bound");
    }

    @Override
    public int getAt(String name) {
        return this.getValue(name);
    }

    @Override
    public double getValueReal(String name) {
        int i = this.getIndexOfReal(name);
        if (this.realResults[i].bound) {
            return (this.realResults[i].min + this.realResults[i].max) / 2.0;
        }
        throw new RuntimeException("real variable " + name + " is not bound");
    }

    @Override
    public String getValueString(String name) {
        int intValue = this.getValue(name);
        AbstractProblem p = (AbstractProblem)this.getProblem();
        VarString varString = p.getVarString(name);
        return varString.getValue(intValue);
    }

    @Override
    public Set<Integer> getValueSet(String name) {
        int i = this.getIndexOfSet(name);
        if (this.setResults[i].bound) {
            return this.setResults[i].value;
        }
        throw new RuntimeException("Set variable " + name + " is not bound");
    }

    public int getMin(int i) {
        return this.intResults[i].min;
    }

    @Override
    public int getMin(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].min;
    }

    public int getMax(int i) {
        return this.intResults[i].max;
    }

    @Override
    public int getMax(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].max;
    }

    @Override
    public boolean isBound(String name) {
        int i = this.getIndexOfInt(name);
        return this.intResults[i].bound;
    }

    private int getIndexOfInt(String name) {
        if (this.intResults != null) {
            for (int i = 0; i < this.intResults.length; ++i) {
                if (!name.equals(this.intResults[i].varName)) continue;
                return i;
            }
        }
        throw new RuntimeException("ERROR: variable " + name + " not found in Solution");
    }

    public double getMinReal(int i) {
        return this.realResults[i].min;
    }

    public double getMaxReal(int i) {
        return this.realResults[i].max;
    }

    private int getIndexOfReal(String name) {
        if (this.realResults != null) {
            for (int i = 0; i < this.realResults.length; ++i) {
                if (!name.equals(this.realResults[i].varName)) continue;
                return i;
            }
        }
        throw new RuntimeException("ERROR: real variable " + name + " not found in Solution");
    }

    private int getIndexOfSet(String name) {
        if (this.setResults != null) {
            for (int i = 0; i < this.setResults.length; ++i) {
                if (!name.equals(this.setResults[i].varName)) continue;
                return i;
            }
        }
        throw new RuntimeException("ERROR: set variable " + name + " not found in Solution");
    }

    @Override
    public boolean isBound() {
        for (int i = 0; i < this.intResults.length; ++i) {
            if (this.intResults[i].bound) continue;
            return false;
        }
        return true;
    }

    @Override
    public void save() {
        int i;
        if (this.intResults != null) {
            for (i = 0; i < this.intResults.length; ++i) {
                this.intResults[i].save();
            }
        }
        if (this.realResults != null) {
            for (i = 0; i < this.realResults.length; ++i) {
                this.realResults[i].save();
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.intResults != null) {
            for (int i = 0; i < this.intResults.length; ++i) {
                if (i > 0 && i % varPerLine == 0) {
                    buf.append("\n\t");
                }
                buf.append(" " + this.intResults[i].toString());
            }
        }
        return "Solution #" + this.solutionNumber + ":\n\t" + buf.toString();
    }

    @Override
    public void log() {
        this.getProblem().log(this.toString());
    }

    @Override
    public void log(int varPerLinePar) {
        varPerLine = varPerLinePar;
        this.log();
    }

    public void logVars() {
        for (int i = 0; i < this.intResults.length; ++i) {
            this.getProblem().log(this.intResults[i].toString());
        }
    }

    public void logVarReals() {
        for (int i = 0; i < this.realResults.length; ++i) {
            this.getProblem().log(this.realResults[i].toString());
        }
    }

    public void logVarSets() {
        for (int i = 0; i < this.setResults.length; ++i) {
            this.getProblem().log(this.setResults[i].toString());
        }
    }

    ResultInt createResult(Var var) {
        ResultInt result = new ResultInt();
        result.varName = var.getName();
        if (var.isBound()) {
            result.min = result.value = var.getValue();
            result.max = result.value;
            result.bound = true;
        } else {
            result.min = var.getMin();
            result.max = var.getMax();
            result.bound = false;
        }
        return result;
    }

    class ResultSet {
        String varName;
        Set value;
        Set possible;
        Set required;
        boolean bound;

        ResultSet() {
        }

        public String toString() {
            return this.varName;
        }
    }

    class ResultReal {
        String varName;
        double value;
        double min;
        double max;
        boolean bound;

        ResultReal() {
        }

        public String toString() {
            if (this.bound) {
                return this.varName + "[" + this.value + "]";
            }
            return this.varName + "[" + this.min + ".." + this.max + "]";
        }

        public void save() {
            Problem p = BasicSolution.this.getProblem();
            VarReal var = p.getVarReal(this.varName);
            if (var != null) {
                p.post(var, ">=", this.min);
                p.post(var, "<=", this.max);
            }
        }
    }

    class ResultInt {
        String varName;
        int value;
        int min;
        int max;
        boolean bound;

        ResultInt() {
        }

        public String toString() {
            if (this.bound) {
                return this.varName + "[" + this.value + "]";
            }
            return this.varName + "[" + this.min + ".." + this.max + "]";
        }

        public void save() {
            Problem p = BasicSolution.this.getProblem();
            Var var = p.getVar(this.varName);
            if (var != null) {
                p.post(var, ">=", this.min);
                p.post(var, "<=", this.max);
            }
        }
    }
}

