/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search;

import java.util.Vector;
import javax.constraints.ProblemState;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.SolutionIterator;
import javax.constraints.Var;
import javax.constraints.impl.constraint.ConstraintNotAllEqual;
import javax.constraints.impl.search.AbstractSolver;
import javax.constraints.impl.search.BasicSolution;

public class BasicSolutionIterator
implements SolutionIterator {
    AbstractSolver solver;
    Solution solution;
    int solutionNumber;
    boolean noSolutions;
    long startTime;

    public BasicSolutionIterator(AbstractSolver solver) {
        this.solver = solver;
        this.solution = null;
        this.noSolutions = false;
        this.solutionNumber = 0;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public boolean hasNext() {
        block6: {
            if (this.noSolutions) {
                return false;
            }
            this.solver.setTimeLimitStart();
            this.solution = null;
            long solutionTimeLimit = this.solver.getTimeLimit();
            long globalTimeLimit = this.solver.getTimeLimitGlobal();
            try {
                if (globalTimeLimit > 0L) {
                    long spentTime = System.currentTimeMillis() - this.startTime;
                    if (spentTime > globalTimeLimit) {
                        this.solver.log("Global time limit " + globalTimeLimit + " millis has been exceeded.");
                        return false;
                    }
                    if (spentTime + solutionTimeLimit > globalTimeLimit) {
                        this.solver.setTimeLimit((int)(globalTimeLimit - spentTime));
                    }
                }
                this.solution = this.solver.findSolution(ProblemState.RESTORE);
            }
            catch (Exception e) {
                if (solutionTimeLimit <= 0L) break block6;
                this.solver.log("Time limit " + solutionTimeLimit + " mills for one solution search has been exceeded");
            }
        }
        return this.solution != null;
    }

    @Override
    public Solution next() {
        if (this.solution == null) {
            throw new RuntimeException("Cannot use SolutionIterator.next() before checking the hasNext() returned true");
        }
        this.solution.setSolutionNumber(++this.solutionNumber);
        Vector<SearchStrategy> searchStrategies = this.solver.getSearchStrategies();
        Vector<Var> strategyVars = new Vector<Var>();
        for (SearchStrategy strategy : searchStrategies) {
            Var[] vars;
            for (Var var : vars = strategy.getVars()) {
                if (strategyVars.contains(var)) continue;
                strategyVars.add(var);
            }
        }
        Var[] vars = ((BasicSolution)this.solution).getVars();
        int[] values = new int[vars.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.solution.getValue(vars[i].getName());
        }
        try {
            new ConstraintNotAllEqual(vars, values).post();
        }
        catch (Exception e) {
            this.noSolutions = true;
        }
        return this.solution;
    }
}

