/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import java.util.Calendar;
import javax.constraints.ProblemState;
import javax.constraints.Solution;
import javax.constraints.Var;
import javax.constraints.impl.AbstractProblem;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalSaveSolution;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class Dichotomize {
    SolverWithGoals solver;
    Var objective;
    Goal searchGoal;
    int objectiveMin;
    int objectiveMax;
    int tolerance;
    int numberOfSolutions;
    int numberOfChoicePoints;
    int numberOfFailures;
    int numberOfTries;
    boolean checkLowerHalf;
    Solution solution;
    AbstractProblem p;
    int prevMax;
    int midObjective;
    int timeLimit;
    int timeLimitGlobal;
    long startTime;

    public Dichotomize(SolverWithGoals solver, Var objective) {
        this.solver = solver;
        this.p = (AbstractProblem)solver.getProblem();
        this.searchGoal = solver.combineSearchStrategies();
        this.searchGoal = this.searchGoal.and(new GoalSaveSolution(solver));
        this.objective = objective;
        if (objective.getName().isEmpty()) {
            objective.setName("Objective");
        }
        if (this.p.getVar(objective.getName()) == null) {
            this.p.add(objective);
        }
        this.objectiveMin = objective.getMin();
        this.objectiveMax = objective.getMax();
        this.tolerance = solver.getOptimizationTolerance();
        this.timeLimit = solver.getTimeLimit();
        if (this.timeLimit <= 0) {
            this.p.log("Use default time limit per solution: 120 seconds");
            solver.setTimeLimit(120);
        }
        this.timeLimitGlobal = solver.getTimeLimitGlobal();
        this.startTime = System.currentTimeMillis();
        this.checkLowerHalf = false;
        this.numberOfTries = 0;
        this.solution = null;
        this.prevMax = 0;
        this.midObjective = 0;
    }

    public Solution execute() {
        block11: {
            long currentTime = System.currentTimeMillis();
            if (this.timeLimitGlobal > 0 && currentTime - this.startTime > (long)this.timeLimitGlobal) {
                this.p.log("The search is interrupted by Time Limit Global " + this.timeLimitGlobal + " milliseconds");
                return this.solution;
            }
            this.p.log("Dichotomize with objective " + this.objective + " within [" + this.objectiveMin + ";" + this.objectiveMax + "]");
            ++this.numberOfTries;
            this.solver.setTimeLimitStart();
            Goal minGoal = this.solver.goalVarGeValue(this.objective, this.objectiveMin);
            Goal maxGoal = this.solver.goalVarLeValue(this.objective, this.objectiveMax);
            Goal runGoal = minGoal.and(maxGoal).and(this.searchGoal);
            Solution newSolution = null;
            try {
                if (this.solver.execute(runGoal, ProblemState.RESTORE)) {
                    newSolution = this.solver.getSolution();
                    ++this.numberOfSolutions;
                    this.solution = newSolution;
                    this.solution.setSolutionNumber(this.numberOfSolutions);
                    int objectiveValue = this.solution.getValue(this.objective.getName());
                    if (this.solver.isTraceSolutions()) {
                        this.p.log("Found solution #" + this.numberOfSolutions + " objective=" + objectiveValue + ". " + Calendar.getInstance().getTime());
                    }
                    this.objectiveMax = objectiveValue - this.tolerance;
                    if (Math.abs(objectiveValue - this.objectiveMin) <= 0) {
                        this.p.debug("This solution is optimal!");
                        return this.solution;
                    }
                    int maxSolutions = this.solver.getMaxNumberOfSolutions();
                    if (maxSolutions > 0 && this.numberOfSolutions == maxSolutions) {
                        String msg = "The search is interrupted: MaxNumberOfSolutions " + maxSolutions + " has been reached";
                        this.solver.addExplanation(msg);
                        this.p.log(msg);
                        return this.solution;
                    }
                    this.midObjective = (int)Math.floor((this.objectiveMin + this.objectiveMax) / 2);
                    if (this.midObjective == this.objectiveMax) {
                        this.midObjective = this.objectiveMin;
                    }
                    this.prevMax = this.objectiveMax;
                    this.objectiveMax = this.midObjective;
                    this.checkLowerHalf = true;
                    return this.execute();
                }
            }
            catch (Exception e) {
                if (this.solver.getTimeLimit() <= 0) break block11;
                String msg = "Dichotomize: Time limit " + this.solver.getTimeLimit() + " mills for one solution search has been exceeded";
                this.solver.addExplanation(msg);
                this.p.log(msg);
            }
        }
        if (this.checkLowerHalf) {
            ++this.midObjective;
            this.objectiveMax = this.prevMax - 1;
            if (this.midObjective > this.objectiveMax) {
                return this.solution;
            }
            this.objectiveMin = this.midObjective;
            this.checkLowerHalf = false;
            return this.execute();
        }
        String text = "No solutions";
        if (this.solution != null) {
            text = "Last solution was optimal!";
        }
        this.p.debug(text);
        return this.solution;
    }
}

