/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.SearchStrategy;
import javax.constraints.Solver;
import javax.constraints.impl.search.AbstractSearchStrategy;
import javax.constraints.impl.search.goal.SolverWithGoals;

public abstract class Goal
extends AbstractSearchStrategy {
    SolverWithGoals solver;

    public Goal(Solver solver) {
        this(solver, "");
    }

    public Goal(Solver solver, String name) {
        super(solver);
        this.setType(SearchStrategy.SearchStrategyType.GOAL);
        this.setName(name);
        this.solver = (SolverWithGoals)solver;
        this.setImpl(this.solver.goalThis(this));
    }

    public abstract Goal execute() throws Exception;

    @Override
    public SolverWithGoals getSolver() {
        return this.solver;
    }

    public Goal and(Goal goal) {
        return this.solver.and(this, goal);
    }

    public Goal or(Goal goal) {
        return this.solver.or(this, goal);
    }

    @Override
    public final void trace() {
        if (this.solver.isTraceExecution()) {
            this.getProblem().log("Goal: " + this.getName());
        }
    }
}

