/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Constraint;
import javax.constraints.Problem;
import javax.constraints.ValueSelector;
import javax.constraints.Var;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalConstraint;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalAssignValueTimeLimit
extends Goal {
    Var var;
    ValueSelector valueSelector;

    public GoalAssignValueTimeLimit(Var var, ValueSelector valueSelector) {
        super(var.getProblem().getSolver(), "AssignValueWithTimeLimit to " + var);
        this.var = var;
        this.valueSelector = valueSelector;
    }

    @Override
    public Goal execute() throws Exception {
        Problem p = this.getProblem();
        this.trace();
        if (this.var.isBound()) {
            return null;
        }
        SolverWithGoals solver = this.getSolver();
        if (solver.checkTimeLimit()) {
            if (!solver.isTimeLimitExceeded()) {
                solver.setTimeLimitExceeded(true);
                p.log("Time limit " + solver.getTimeLimit() + " has been exceeded while instantiating variable " + this.var.getName());
            }
            return null;
        }
        int value = this.valueSelector.select(this.var);
        Constraint assign = p.linear(this.var, "=", value);
        GoalConstraint goalAssignValue = new GoalConstraint(assign);
        Constraint remove = p.linear(this.var, "!=", value);
        GoalConstraint goalRemoveValue = new GoalConstraint(remove);
        return goalAssignValue.or(goalRemoveValue.and(this));
    }
}

