/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import java.util.ArrayList;
import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.Var;
import javax.constraints.VarSelector;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalAssignValue;
import javax.constraints.impl.search.selectors.ValueSelectorMin;
import javax.constraints.impl.search.selectors.VarSelectorInputOrder;

public class GoalAssignValues
extends Goal {
    protected Goal[] goals;

    public GoalAssignValues(Var[] vars, VarSelector varSelector, ValueSelector valueSelector) {
        super(vars[0].getProblem().getSolver(), "AssignValues");
        this.setVarSelector(varSelector);
        this.setValueSelector(valueSelector);
        this.setVars(vars);
    }

    public GoalAssignValues(Solver solver) {
        this(solver, solver.getProblem().getVars());
    }

    public GoalAssignValues(Solver solver, Var[] vars) {
        super(solver, "AssignValues");
        this.setVarSelector(new VarSelectorInputOrder(this));
        this.setValueSelector(new ValueSelectorMin());
        this.setVars(vars);
    }

    public void setGoals(Var[] vars) {
        if (vars == null) {
            return;
        }
        this.goals = new Goal[vars.length];
        ValueSelector valueSelector = this.getValueSelector();
        for (int i = 0; i < vars.length; ++i) {
            this.goals[i] = new GoalAssignValue(vars[i], valueSelector);
        }
    }

    @Override
    public void setVars(Var[] vars) {
        this.vars = vars;
        this.setGoals(vars);
    }

    @Override
    public void setValueSelector(ValueSelector valueSelector) {
        this.valueSelector = valueSelector;
        if (this.vars != null) {
            this.setGoals(this.vars);
        }
    }

    @Override
    public void setVars(ArrayList<Var> varList) {
        Var[] vars = new Var[varList.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = varList.get(i);
        }
        this.setGoals(vars);
    }

    public GoalAssignValues(Var[] vars, VarSelector varSelector) {
        this(vars, varSelector, new ValueSelectorMin());
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        int index = this.getVarSelector().select();
        if (index == -1) {
            return null;
        }
        Goal goal = this.goals[index];
        return goal.and(this);
    }
}

