/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import java.util.ArrayList;
import javax.constraints.Solver;
import javax.constraints.ValueSelector;
import javax.constraints.Var;
import javax.constraints.VarSelector;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalAssignValue;
import javax.constraints.impl.search.goal.GoalCheckTimeLimit;
import javax.constraints.impl.search.selectors.ValueSelectorMin;
import javax.constraints.impl.search.selectors.VarSelectorInputOrder;

public class GoalAssignValuesTimeLimit
extends Goal {
    Var[] vars;
    VarSelector varSelector;
    ValueSelector valueSelector;
    Goal[] goals;
    Goal checkGoal;

    public GoalAssignValuesTimeLimit(Var[] vars, VarSelector varSelector, ValueSelector valueSelector) {
        super(vars[0].getProblem().getSolver(), "AssignValuesWithTimeLimit");
        this.init(vars, varSelector, valueSelector);
    }

    public GoalAssignValuesTimeLimit(Solver solver, Var[] vars) {
        super(solver, "AssignValuesTimeLimit");
        this.init(vars, new VarSelectorInputOrder(this), new ValueSelectorMin());
    }

    public GoalAssignValuesTimeLimit(Solver solver) {
        super(solver, "AssignValuesTimeLimit");
        this.init(solver.getProblem().getVars(), new VarSelectorInputOrder(this), new ValueSelectorMin());
    }

    public void init(Var[] vars, VarSelector varSelector, ValueSelector valueSelector) {
        this.vars = vars;
        this.varSelector = varSelector;
        this.valueSelector = valueSelector;
        this.checkGoal = new GoalCheckTimeLimit(this.getSolver());
        this.createGoals(vars);
    }

    public void createGoals(Var[] vars) {
        this.goals = new Goal[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            this.goals[i] = new GoalAssignValue(vars[i], this.valueSelector);
        }
        this.checkGoal = new GoalCheckTimeLimit(this.getSolver());
    }

    @Override
    public void setVars(Var[] vars) {
        this.createGoals(vars);
    }

    @Override
    public void setVars(ArrayList<Var> varList) {
        Var[] vars = new Var[varList.size()];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = varList.get(i);
        }
        this.createGoals(vars);
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        int index = this.varSelector.select();
        if (index == -1) {
            return null;
        }
        return this.goals[index].and(this);
    }
}

