/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Solver;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalCheckMaxNumberOfSolutions
extends Goal {
    public GoalCheckMaxNumberOfSolutions(Solver solver) {
        super(solver, "check max solutions");
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        SolverWithGoals solver = this.getSolver();
        int max = solver.getMaxNumberOfSolutions();
        if (max <= 0) {
            return null;
        }
        if (solver.getSolutions() == null || solver.getNumberOfSolutions() == max) {
            String msg = "Search interrupted by the MaxNumberOfSolutions: " + max;
            solver.log(msg);
            solver.addExplanation(msg);
            solver.backtrack();
            return null;
        }
        return null;
    }
}

