/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Problem;
import javax.constraints.Solver;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalCheckTimeLimit
extends Goal {
    GoalCheckTimeLimit(Solver solver) {
        super(solver, "CheckTimeLimit");
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        SolverWithGoals solver = this.getSolver();
        Problem problem = solver.getProblem();
        if (solver.checkTimeLimit()) {
            if (!solver.isTimeLimitExceeded()) {
                solver.setTimeLimitExceeded(true);
                String msg = "Time limit " + solver.getTimeLimit() + " has been exceeded";
                solver.addExplanation(msg);
                problem.log(msg);
            }
            solver.backtrack();
        }
        return null;
    }
}

