/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import javax.constraints.Problem;
import javax.constraints.Solver;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.SolverWithGoals;

public class GoalCheckTotalTimeLimit
extends Goal {
    int totalTimeLimit;
    long startTime = System.currentTimeMillis();

    public GoalCheckTotalTimeLimit(Solver solver) {
        super(solver, "CheckTotalTimeLimit");
    }

    @Override
    public Goal execute() throws Exception {
        this.trace();
        SolverWithGoals solver = this.getSolver();
        Problem problem = solver.getProblem();
        long currTime = System.currentTimeMillis();
        int timeLimit = solver.getTimeLimit();
        if (timeLimit > 0 && (long)timeLimit < currTime - this.startTime) {
            String msg = "The search is interrupted by TimeLimit " + timeLimit + " milliseconds";
            solver.addExplanation(msg);
            problem.log(msg);
            solver.backtrack();
        }
        return null;
    }
}

