/*
 * Decompiled with CFR 0.152.
 */
package javax.constraints.impl.search.goal;

import java.util.Vector;
import javax.constraints.Constraint;
import javax.constraints.Objective;
import javax.constraints.Problem;
import javax.constraints.ProblemState;
import javax.constraints.SearchStrategy;
import javax.constraints.Solution;
import javax.constraints.Solver;
import javax.constraints.Var;
import javax.constraints.VarSet;
import javax.constraints.extra.ConstraintTraceVar;
import javax.constraints.extra.PropagationEvent;
import javax.constraints.impl.BasicVarSet;
import javax.constraints.impl.search.AbstractSolver;
import javax.constraints.impl.search.goal.Dichotomize;
import javax.constraints.impl.search.goal.Goal;
import javax.constraints.impl.search.goal.GoalAddSolution;
import javax.constraints.impl.search.goal.GoalApplySolution;
import javax.constraints.impl.search.goal.GoalAssignValues;
import javax.constraints.impl.search.goal.GoalAssignValuesTimeLimit;
import javax.constraints.impl.search.goal.GoalBacktrack;
import javax.constraints.impl.search.goal.GoalCheckMaxNumberOfSolutions;
import javax.constraints.impl.search.goal.GoalConstraint;
import javax.constraints.impl.search.goal.StrategyAsGoal;

public abstract class SolverWithGoals
extends AbstractSolver {
    public SolverWithGoals(Problem problem) {
        super(problem);
    }

    @Override
    public SearchStrategy newSearchStrategy() {
        return new GoalAssignValues(this);
    }

    public abstract Object goalThis(Goal var1);

    public abstract boolean execute(Goal var1, ProblemState var2);

    public Goal goalVarEqValue(Var var, int value) {
        Constraint assign = this.getProblem().linear(var, "=", value);
        GoalConstraint goalAssignValue = new GoalConstraint(assign);
        goalAssignValue.setName("Assign " + value + " to " + var);
        return goalAssignValue;
    }

    public Goal goalVarNeqValue(Var var, int value) {
        Constraint remove = this.getProblem().linear(var, "!=", value);
        GoalConstraint goalRemoveValue = new GoalConstraint(remove);
        goalRemoveValue.setName("Remove " + value + " from " + var);
        return goalRemoveValue;
    }

    public Goal goalVarLeValue(Var var, int value) {
        Constraint c = this.getProblem().linear(var, "<=", value);
        c.setName("" + var + " <= " + value);
        GoalConstraint goalLeValue = new GoalConstraint(c);
        return goalLeValue;
    }

    public Goal goalVarGeValue(Var var, int value) {
        Constraint c = this.getProblem().linear(var, ">=", value);
        c.setName("" + var + " >= " + value);
        GoalConstraint goalGeValue = new GoalConstraint(c);
        return goalGeValue;
    }

    public abstract Goal and(Goal var1, Goal var2);

    public abstract Goal or(Goal var1, Goal var2);

    public boolean execute(Goal goal) {
        return this.execute(goal, ProblemState.DO_NOT_RESTORE);
    }

    @Override
    public Solution findSolution(ProblemState restoreOrNot) {
        this.clearSolutions();
        Solution solution = null;
        Goal searchGoal = this.combineSearchStrategies();
        Goal goalSearchAndSave = searchGoal.and(new GoalAddSolution(this));
        if (this.execute(goalSearchAndSave, restoreOrNot)) {
            solution = this.getSolution();
        }
        if (solution != null && !solution.isBound() && searchGoal instanceof GoalAssignValuesTimeLimit) {
            this.setTimeLimitExceeded(true);
            String msg = "Solver exceeded Time Limit " + this.getTimeLimit() + " milliseconds";
            this.addExplanation(msg);
            this.getProblem().log(msg);
            solution = null;
        }
        return solution;
    }

    @Override
    public Solution[] findAllSolutions() {
        this.clearSolutions();
        Goal searchGoal = this.combineSearchStrategies();
        GoalAddSolution addGoal = new GoalAddSolution((Solver)this, -1);
        GoalCheckMaxNumberOfSolutions maxGoal = new GoalCheckMaxNumberOfSolutions(this);
        GoalBacktrack backtrackGoal = new GoalBacktrack(this);
        Goal goal1 = searchGoal.and(addGoal);
        Goal goal2 = maxGoal.or(backtrackGoal);
        Goal goal = goal1.and(goal2);
        this.execute(goal, ProblemState.RESTORE);
        return this.getSolutions();
    }

    public Goal makeGoal(SearchStrategy strategy) {
        Goal goal = strategy.getType().equals((Object)SearchStrategy.SearchStrategyType.CUSTOM) ? new StrategyAsGoal((Solver)this, strategy) : (Goal)strategy;
        return goal;
    }

    public Goal combineSearchStrategies() {
        Vector<SearchStrategy> searchStrategies = this.getSearchStrategies();
        Goal combinedGoal = this.makeGoal(searchStrategies.elementAt(0));
        for (int i = 1; i < searchStrategies.size(); ++i) {
            Goal nextGoal = this.makeGoal(searchStrategies.elementAt(i));
            combinedGoal = combinedGoal.and(nextGoal);
        }
        return combinedGoal;
    }

    @Override
    public Solution findOptimalSolutionDichotomize(Objective objective, Var objectiveVar) {
        long startTime = System.currentTimeMillis();
        if (objectiveVar.getName().isEmpty()) {
            objectiveVar.setName("Objective");
        }
        if (this.getProblem().getVar(objectiveVar.getName()) == null) {
            this.getProblem().add(objectiveVar);
        }
        Var obj = objectiveVar;
        if (objective.equals((Object)Objective.MAXIMIZE)) {
            obj = objectiveVar.multiply(-1);
            obj.setName("-" + objectiveVar.getName());
            this.getProblem().add(obj);
        }
        this.addObjective(obj);
        Dichotomize dichotomize = new Dichotomize(this, obj);
        Solution solution = dichotomize.execute();
        if (solution != null) {
            this.log("Optimal solution is found. Objective: " + solution.getValue(obj.getName()));
        }
        return solution;
    }

    @Override
    public boolean applySolution(Solution solution) {
        return this.execute(new GoalApplySolution(solution));
    }

    public abstract void backtrack() throws Exception;

    @Override
    public void trace(Var var) {
        this.trace(var, PropagationEvent.ANY);
    }

    public void trace(Var var, PropagationEvent event) {
        if (event == PropagationEvent.ANY) {
            this.trace(var, PropagationEvent.MIN);
            this.trace(var, PropagationEvent.MAX);
            this.trace(var, PropagationEvent.REMOVE);
            this.trace(var, PropagationEvent.VALUE);
        } else if (event == PropagationEvent.RANGE) {
            this.trace(var, PropagationEvent.MIN);
            this.trace(var, PropagationEvent.MAX);
        } else {
            new ConstraintTraceVar(var, event).post();
        }
    }

    @Override
    public void trace(Var[] vars) {
        this.trace(vars, PropagationEvent.ANY);
    }

    public void trace(Var[] vars, PropagationEvent event) {
        for (int i = 0; i < vars.length; ++i) {
            this.trace(vars[i], event);
        }
    }

    @Override
    public void trace(VarSet setVar) {
        this.trace(setVar, PropagationEvent.ANY);
    }

    public void trace(VarSet setVar, PropagationEvent event) {
        Var indexVar = setVar.getCardinality();
        this.trace(indexVar, event);
        BasicVarSet basicSetVar = (BasicVarSet)setVar;
        Var[] requiredVars = basicSetVar.getRequiredVars();
        this.trace(requiredVars, event);
    }
}

