/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.djcproxy;

import com.javax0.djcproxy.CallbackFilter;
import java.util.Map;
import java.util.WeakHashMap;

public class ProxyClassCache<ClassToBeProxied> {
    private final Map<Key, Class<?>> cache = new WeakHashMap();

    public Class<?> get(Class<?> originalClass, CallbackFilter filter, ClassLoader classLoader) {
        Key key = new Key();
        key.originalClass = originalClass;
        key.filter = filter;
        key.classLoader = classLoader;
        Class<?> proxyClass = this.cache.get(key);
        return proxyClass;
    }

    public void put(Class<?> originalClass, CallbackFilter filter, ClassLoader classLoader, Class<?> proxyClass) {
        Key key = new Key();
        key.originalClass = originalClass;
        key.filter = filter;
        key.classLoader = classLoader;
        this.cache.put(key, proxyClass);
    }

    private static class Key {
        ClassLoader classLoader;
        CallbackFilter filter;
        Class<?> originalClass;

        private Key() {
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classLoader == null ? 0 : this.classLoader.hashCode());
            result = 31 * result + (this.filter == null ? 0 : this.filter.hashCode());
            result = 31 * result + (this.originalClass == null ? 0 : this.originalClass.hashCode());
            return result;
        }

        private boolean safeEquals(Object a, Object b) {
            if (a == null && b == null) {
                return true;
            }
            if (a == null) {
                return false;
            }
            return a.equals(b);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (!this.safeEquals(this.classLoader, other.classLoader)) {
                return false;
            }
            if (!this.safeEquals(this.filter, other.filter)) {
                return false;
            }
            return this.safeEquals(this.originalClass, other.originalClass);
        }
    }
}

