/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.djcproxy;

import com.javax0.djcproxy.CallbackFilter;
import com.javax0.djcproxy.MethodInterceptor;
import com.javax0.djcproxy.ProxyClassCache;
import com.javax0.djcproxy.ProxySetter;
import com.javax0.djcproxy.ProxySourceFactory;
import com.javax0.djcproxy.exceptions.ProxyClassCompilerError;
import com.javax0.jscc.Compiler;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import sun.misc.Unsafe;

public class ProxyFactory<ClassToBeProxied> {
    private ProxyClassCache<ClassToBeProxied> cache = new ProxyClassCache();
    private CallbackFilter callbackFilter = new CallbackFilter(){

        @Override
        public boolean accept(Method method) {
            return true;
        }
    };
    private ClassLoader classLoader = null;
    private String source;
    private String generatedClassName;
    private String compilerErrorOutput;

    public void setCallbackFilter(CallbackFilter callbackFilter) {
        if (callbackFilter == null) {
            throw new IllegalArgumentException("callback filter can not be null");
        }
        this.callbackFilter = callbackFilter;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getGeneratedSource() {
        return this.source;
    }

    public String getGeneratedClassName() {
        return this.generatedClassName;
    }

    public String getCompilerErrorOutput() {
        return this.compilerErrorOutput;
    }

    public ClassToBeProxied create(ClassToBeProxied originalObject, MethodInterceptor interceptor) throws Exception {
        Class<?> originalClass = originalObject.getClass();
        ClassLoader classLoader = this.calculateClassLoader(originalClass);
        Class<?> proxyClass = this.cache.get(originalObject.getClass(), this.callbackFilter, classLoader);
        if (proxyClass == null) {
            proxyClass = this.createClass(originalObject.getClass());
            this.cache.put(originalClass, this.callbackFilter, classLoader, proxyClass);
        }
        ProxySetter proxy = this.instantiateProxy(proxyClass);
        proxy.setPROXY$OBJECT(originalObject);
        proxy.setPROXY$INTERCEPTOR(interceptor);
        return this.cast(proxy);
    }

    private ClassLoader calculateClassLoader(Class<?> originalClass) {
        return this.classLoader == null ? originalClass.getClassLoader() : this.classLoader;
    }

    public Class<?> createClass(Class<?> originalClass) throws Exception {
        ProxySourceFactory sourceFactory = new ProxySourceFactory(this.callbackFilter);
        this.source = sourceFactory.create(originalClass);
        this.generatedClassName = sourceFactory.getGeneratedClassName();
        Compiler compiler = new Compiler();
        compiler.setClassLoader(this.calculateClassLoader(originalClass));
        String classFQN = sourceFactory.getGeneratedPackageName() + "." + sourceFactory.getGeneratedClassName();
        Class proxyClass = compiler.compile(this.source, classFQN);
        this.compilerErrorOutput = compiler.getCompilerErrorOutput();
        if (proxyClass == null) {
            throw new ProxyClassCompilerError(compiler.getCompilerErrorOutput());
        }
        return proxyClass;
    }

    public ProxySetter instantiateProxy(Class<?> proxyClass) throws Exception {
        ProxySetter proxy;
        Unsafe unsafe;
        if (proxyClass == null) {
            throw new IllegalArgumentException("proxyClass can not be null");
        }
        try {
            Field f = Unsafe.class.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unsafe = (Unsafe)f.get(null);
        }
        catch (Exception e) {
            unsafe = null;
        }
        if (unsafe == null) {
            Constructor<?> constructor = proxyClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            proxy = (ProxySetter)constructor.newInstance(new Object[0]);
        } else {
            proxy = (ProxySetter)unsafe.allocateInstance(proxyClass);
        }
        return proxy;
    }

    private ClassToBeProxied cast(Object proxy) {
        return (ClassToBeProxied)proxy;
    }
}

