/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.djcproxy;

import com.javax0.djcproxy.CallbackFilter;
import com.javax0.djcproxy.MethodInterceptor;
import com.javax0.djcproxy.MethodProxy;
import com.javax0.djcproxy.ProxySetter;
import com.javax0.djcproxy.exceptions.FinalCanNotBeExtendedException;
import com.javax0.djcproxy.utilities.Generics;
import com.javax0.jscglib.JSC;
import com.javax0.jscglib.JSCBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.LinkedList;

class ProxySourceFactory<Proxy> {
    private final CallbackFilter callbackFilter;
    private JSC builder;
    private Class<?> klass;
    private String generatedClassName;
    private String generatedPackageName;
    private static final String PROXY_OBJECT_FIELD_NAME = "PROXY$OBJECT";
    private static final String INTERCEPTOR_FIELD_NAME = "PROXY$INTERCEPTOR";

    public ProxySourceFactory(CallbackFilter callbackFilter) {
        this.callbackFilter = callbackFilter;
    }

    public String getGeneratedClassName() {
        return this.generatedClassName;
    }

    private void calculateClassName(Class<?> klass) {
        this.generatedClassName = "PROXY$CLASS$" + klass.getSimpleName();
    }

    public String getGeneratedPackageName() {
        return this.generatedPackageName;
    }

    private void calculatePackageName(Package originalPackage) {
        String[] forbiddenPackages;
        String originalPackageName = originalPackage.getName();
        for (String prefix : forbiddenPackages = new String[]{"java.", "javax."}) {
            if (!originalPackageName.startsWith(prefix)) continue;
            this.generatedPackageName = "p." + originalPackageName;
            return;
        }
        this.generatedPackageName = originalPackageName;
    }

    public String create(Class<?> originalClass) throws FinalCanNotBeExtendedException {
        this.klass = originalClass;
        this.assertClassIsNotFinal();
        this.calculateClassName(this.klass);
        this.calculatePackageName(this.klass.getPackage());
        this.builder = JSCBuilder.klass((String)this.generatedClassName).inPackage(this.generatedPackageName).modifier(new int[]{this.klass.getModifiers() & 0xFFFFFFF3}).parent(this.klass).interfaces(new Class[]{ProxySetter.class}).add(JSCBuilder.field(originalClass, (String)PROXY_OBJECT_FIELD_NAME).initNull()).add(JSCBuilder.field(MethodInterceptor.class, (String)INTERCEPTOR_FIELD_NAME).initNull()).add(JSCBuilder.method((String)"void", (String)"setPROXY$OBJECT").modifier(new int[]{1}).arguments(new JSC[]{JSCBuilder.argument(Object.class, (String)PROXY_OBJECT_FIELD_NAME)}).command("this.PROXY$OBJECT = (" + originalClass.getCanonicalName() + ")" + PROXY_OBJECT_FIELD_NAME)).add(JSCBuilder.method((String)"void", (String)"setPROXY$INTERCEPTOR").modifier(new int[]{1}).arguments(new JSC[]{JSCBuilder.argument(MethodInterceptor.class, (String)INTERCEPTOR_FIELD_NAME)}).command("this.PROXY$INTERCEPTOR = PROXY$INTERCEPTOR"));
        for (Constructor<?> constructor : this.klass.getConstructors()) {
            Type[] types = constructor.getGenericParameterTypes();
            this.builder.add(JSCBuilder.constructor((JSC)this.builder).arguments(this.getArguments(types)).command("super(" + this.getCommaSeparatedArgumentLists(types.length) + ")"));
        }
        for (Executable executable : originalClass.getMethods()) {
            this.appendMethodSource((Method)executable);
        }
        return this.builder.toString();
    }

    private void assertClassIsNotFinal() throws FinalCanNotBeExtendedException {
        if ((this.klass.getModifiers() & 0x10) > 0) {
            throw new FinalCanNotBeExtendedException("The class '" + this.klass.getCanonicalName() + "' is final. Proxy can not be created for final classes");
        }
    }

    private void appendMethodSource(Method method) {
        if ((method.getModifiers() & 0x10) == 0) {
            boolean intercept;
            boolean bl = intercept = this.callbackFilter == null || this.callbackFilter.accept(method);
            if (intercept) {
                this.createProxyClassField(method);
            }
            this.createProxyMethod(method, intercept);
        }
    }

    private JSC[] getArguments(Type[] types) {
        LinkedList<String> argTypeList = new LinkedList<String>();
        for (Type type : types) {
            argTypeList.add(Generics.typeToString(type));
        }
        JSC[] arguments = new JSC[argTypeList.size()];
        int i = 0;
        for (String string : argTypeList) {
            arguments[i] = JSCBuilder.argument((String)string, (String)("p" + i));
            ++i;
        }
        return arguments;
    }

    private String getCommaSeparatedArgumentLists(int size) {
        String argnames = "";
        String sep = "";
        for (int i = 0; i < size; ++i) {
            argnames = argnames + sep + "p" + i;
            sep = ",";
        }
        return argnames;
    }

    private String getCommaSeparatedArgumentTypeLists(Class<?>[] parameters) {
        String types = "";
        String sep = "";
        for (Class<?> parameter : parameters) {
            types = types + sep + parameter.getCanonicalName() + ".class";
            sep = ",";
        }
        return types;
    }

    private void appendReturnOptionally(StringBuilder sb, String returnType) {
        if (!"void".equals(returnType)) {
            sb.append("return ");
        }
    }

    private static String claculateMethodProxyFieldName(Method method) {
        return method.getName() + "_MethodProxyInstance";
    }

    private void createProxyClassField(Method method) {
        JSC field = JSCBuilder.field((String)ProxySourceFactory.claculateMethodProxyFieldName(method)).returnType(MethodProxy.class).modifier(new int[]{2}).initValue((Object)"null");
        this.builder.add(field);
    }

    private String createMethodProxy(Method method) {
        JSC invoke = JSCBuilder.method((String)"invoke").modifier(new int[]{1}).arguments(new JSC[]{JSCBuilder.argument(Object.class, (String)"obj"), JSCBuilder.argument(new Object[0].getClass(), (String)"args")}).exceptions(new String[]{"Throwable"}).returnType(Object.class);
        StringBuilder sb = new StringBuilder();
        sb.append("((").append(method.getDeclaringClass().getCanonicalName()).append(")obj).").append(method.getName()).append("(");
        Class<?>[] parameterTypes = method.getParameterTypes();
        int paramNumber = parameterTypes.length;
        for (int index = 0; index < paramNumber; ++index) {
            if (index > 0) {
                sb.append(",");
            }
            if (!parameterTypes[index].equals(Object.class)) {
                sb.append("(").append(parameterTypes[index].getCanonicalName()).append(")");
            }
            sb.append("args[" + index + "]");
        }
        sb.append(")");
        if (method.getReturnType().getCanonicalName().equals("void")) {
            sb.append("; return null");
        } else {
            sb.insert(0, "return ");
        }
        invoke.command(sb.toString());
        return invoke.toString();
    }

    private void createProxyMethod(Method method, boolean intercept) {
        String returnType = Generics.typeToString(method.getGenericReturnType());
        String name = method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        JSC[] arguments = this.getArguments(method.getGenericParameterTypes());
        String argnames = this.getCommaSeparatedArgumentLists(parameters.length);
        String types = this.getCommaSeparatedArgumentTypeLists(parameters);
        StringBuilder sb = new StringBuilder();
        if (intercept) {
            sb.append("\ntry{\n");
            String methodProxyFieldName = ProxySourceFactory.claculateMethodProxyFieldName(method);
            sb.append("if( null == ").append(methodProxyFieldName).append("){").append(methodProxyFieldName).append(" = new com.javax0.djcproxy.MethodProxy() {").append(this.createMethodProxy(method)).append("};}");
            if (!"void".equals(returnType)) {
                sb.append("return (" + method.getReturnType().getCanonicalName() + ")");
            }
            sb.append("PROXY$INTERCEPTOR.intercept(\nPROXY$OBJECT, ");
            sb.append("PROXY$OBJECT.getClass().getMethod(\"" + method.getName() + "\", ");
            sb.append("new Class[]{" + types + "}),\n new Object[]{" + argnames + "},");
            sb.append(ProxySourceFactory.claculateMethodProxyFieldName(method));
            sb.append(");\n");
            sb.append("}catch(Throwable e){\nthrow new RuntimeException(e);\n}\n");
        } else {
            this.appendReturnOptionally(sb, returnType);
            sb.append(PROXY_OBJECT_FIELD_NAME).append(".").append(method.getName()).append("(").append(argnames).append(");");
        }
        this.builder.add(JSCBuilder.method((String)returnType, (String)name).annotation("@Override").modifier(new int[]{method.getModifiers() & 0xFFFFFAFF}).arguments(arguments).commandBlock(sb.toString()));
    }
}

