/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.djcproxy.interceptors;

import com.javax0.djcproxy.MethodInterceptor;
import com.javax0.djcproxy.MethodProxy;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
implements MethodInterceptor {
    Logger LOG = LoggerFactory.getLogger(LoggingInterceptor.class);

    @Override
    public Object intercept(Object obj, Method method, Object[] args, MethodProxy mproxy) throws Throwable {
        this.LOG.trace("Method {}.{} started", (Object)method.getDeclaringClass().getCanonicalName(), (Object)method.getName());
        Object retval = mproxy.invoke(obj, args);
        this.LOG.trace("Method {}.{} finished", (Object)method.getDeclaringClass().getCanonicalName(), (Object)method.getName());
        return retval;
    }
}

