/*
 * Decompiled with CFR 0.152.
 */
package com.javax0.djcproxy.utilities;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.Set;

public class Generics {
    public static String typeToString(Type type) {
        StringBuilder sb = new StringBuilder();
        Generics.typeToString(sb, type, new HashSet<Type>());
        return sb.toString();
    }

    private static void typeToString(StringBuilder sb, Type type, Set<Type> visited) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            sb.append(rawType.getCanonicalName());
            boolean first = true;
            for (Type typeArg : parameterizedType.getActualTypeArguments()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append('<');
                Generics.typeToString(sb, typeArg, visited);
                sb.append('>');
            }
        } else if (type instanceof WildcardType) {
            Type bound;
            WildcardType wildcardType = (WildcardType)type;
            sb.append("?");
            if (wildcardType.getLowerBounds().length != 0) {
                sb.append(" super ");
                bound = wildcardType.getLowerBounds()[0];
            } else {
                sb.append(" extends ");
                bound = wildcardType.getUpperBounds()[0];
            }
            Generics.typeToString(sb, bound, visited);
        } else if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            sb.append(typeVariable.getName());
            if (!visited.contains(type)) {
                visited.add(type);
                sb.append(" extends ");
                boolean first = true;
                for (Type bound : typeVariable.getBounds()) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(" & ");
                    }
                    Generics.typeToString(sb, bound, visited);
                }
                visited.remove(type);
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Generics.typeToString(genericArrayType.getGenericComponentType());
            sb.append(genericArrayType.getGenericComponentType());
            sb.append("[]");
        } else if (type instanceof Class) {
            Class typeClass = (Class)type;
            sb.append(typeClass.getCanonicalName());
        } else {
            throw new IllegalArgumentException("Unsupported type: " + type);
        }
    }
}

