/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.assertions;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.Params;

abstract class AbstractAssert
implements Macro {
    private final int N;
    private final String defaultMessage;
    private final String negatedDefaultMessage;

    protected AbstractAssert(int N, String defaultMessage, String negatedDefaultMessage) {
        this.N = N;
        this.defaultMessage = defaultMessage;
        this.negatedDefaultMessage = negatedDefaultMessage;
    }

    protected abstract boolean test(String[] var1) throws BadSyntax;

    static boolean negateIfNeeded(boolean b, Params.Param<Boolean> not) throws BadSyntax {
        return b == !not.is();
    }

    public String evaluate(Input input, Processor processor) throws BadSyntax {
        String format;
        Params.Param trim = Params.holder((String[])new String[]{"trim", "strip"}).asBoolean();
        Params.Param not = Params.holder((String[])new String[]{"not", "negate"}).asBoolean();
        Params.Param test = Params.holder((String[])new String[]{"test", "boolean", "bool"}).asBoolean();
        Params.using((Processor)processor).from((Identified)this).between("()").keys(new Params.Param[]{trim, not, test}).parse(input);
        String[] parts = AbstractAssert.getParts(input, this.N, (Params.Param<Boolean>)trim, this);
        if (AbstractAssert.negateIfNeeded(this.test(parts), (Params.Param<Boolean>)not)) {
            return test.is() ? "true" : "";
        }
        if (test.is()) {
            return "false";
        }
        String string = format = not.is() ? this.negatedDefaultMessage : this.defaultMessage;
        if (parts.length >= this.N && parts[this.N - 1].trim().length() > 0) {
            throw new BadSyntax(String.format(parts[this.N - 1], parts));
        }
        throw new BadSyntax(this.getId() + " has failed " + String.format(format, parts));
    }

    public String getId() {
        String s = this.getClass().getSimpleName().substring(6);
        return "assert:" + s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    private static String[] getParts(Input input, int N, Params.Param<Boolean> trim, Macro macro) throws BadSyntax {
        String[] parts = InputHandler.getParts((Input)input, (int)N);
        BadSyntax.when((parts.length < N - 1 ? 1 : 0) != 0, () -> macro.getId() + " needs at least " + (N - 1) + " arguments");
        if (trim.is()) {
            for (int i = 0; i < parts.length; ++i) {
                parts[i] = parts[i].strip();
            }
        }
        return parts;
    }
}

