/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.extensions.Case;
import javax0.jamal.tools.InputHandler;

public class Camel {
    private static String sentence(String s) {
        StringBuilder c = new StringBuilder();
        boolean first = true;
        for (char ch : s.toCharArray()) {
            if (Character.isUpperCase(ch) && !first) {
                c.append(" ");
            }
            c.append(Character.toLowerCase(ch));
            first = false;
        }
        return c.toString();
    }

    private static String cstyle(String s, char sep) {
        StringBuilder c = new StringBuilder();
        boolean first = true;
        for (char ch : s.toCharArray()) {
            if (Character.isUpperCase(ch) && !first) {
                c.append(sep);
            }
            c.append(Character.toUpperCase(ch));
            first = false;
        }
        return c.toString();
    }

    private static String camelCase(String s) {
        StringBuilder cased = new StringBuilder();
        boolean inside = true;
        for (char c : s.toCharArray()) {
            if (Character.isAlphabetic(c) || Character.isDigit(c)) {
                cased.append(inside ? Character.toLowerCase(c) : Character.toUpperCase(c));
                inside = true;
                continue;
            }
            inside = false;
        }
        return cased.toString();
    }

    public static class Sentence
    implements Macro {
        public String evaluate(Input in, Processor processor) {
            InputHandler.skipWhiteSpaces((Input)in);
            return Camel.sentence(in.toString().trim());
        }
    }

    public static class CStyle
    implements Macro {
        public String evaluate(Input in, Processor processor) {
            InputHandler.skipWhiteSpaces((Input)in);
            char sep = in.charAt(0);
            InputHandler.skip((Input)in, (int)1);
            return Camel.cstyle(in.toString(), sep);
        }
    }

    public static class UppCamel
    implements Macro {
        public String evaluate(Input in, Processor processor) {
            return Case.capitalize(Camel.camelCase(in.toString().trim()));
        }
    }

    public static class LowCamel
    implements Macro {
        public String evaluate(Input in, Processor processor) {
            return Camel.camelCase(in.toString().trim());
        }
    }
}

