/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.BadSyntaxAt;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Position;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.FileTools;
import javax0.jamal.tools.InputHandler;

public class FileMacros {
    private static String getAbsoluteFileName(Input in, String reference, String inputFileName) throws BadSyntaxAt {
        String fileName;
        if (FileTools.isAbsolute((String)inputFileName)) {
            fileName = inputFileName;
        } else {
            BadSyntaxAt.when((reference == null ? 1 : 0) != 0, (String)"Cannot use file macro in a file that has no reference", (Position)in.getPosition());
            fileName = FileTools.absolute((String)reference, (String)inputFileName);
        }
        return fileName;
    }

    public static class Write
    implements Macro {
        public String evaluate(Input in, Processor processor) throws BadSyntax {
            String reference = in.getReference();
            String[] parts = InputHandler.getParts((Input)in, (int)2);
            BadSyntaxAt.when((parts.length < 2 ? 1 : 0) != 0, (String)("Write macro needs two arguments but got " + parts.length), (Position)in.getPosition());
            String inputFileName = parts[0];
            String content = parts[1];
            String fileName = FileMacros.getAbsoluteFileName(in, reference, inputFileName);
            FileTools.writeFileContent((String)fileName, (String)content, (Processor)processor);
            return "";
        }
    }

    public static class Read
    implements Macro {
        public String evaluate(Input in, Processor processor) throws BadSyntax {
            InputHandler.skipWhiteSpaces((Input)in);
            String reference = in.getReference();
            String inputFileName = in.toString().trim();
            String fileName = FileMacros.getAbsoluteFileName(in, reference, inputFileName);
            return FileTools.getFileContent((String)fileName, (Processor)processor);
        }
    }
}

