/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import java.util.Arrays;
import java.util.Optional;
import java.util.regex.Pattern;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Evaluable;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;

public class IndexStringTable
implements Macro {
    private static final String DEFAULT = "|/:-.";

    public String evaluate(Input in, Processor processor) throws BadSyntax {
        Optional optionalForSepMacro = processor.getRegister().getUserDefined("$getsep");
        String splitters = optionalForSepMacro.filter(ud -> ud instanceof Evaluable).map(ud -> (Evaluable)ud).map(udm -> {
            try {
                return udm.evaluate(new String[0]);
            }
            catch (BadSyntax bs) {
                return DEFAULT;
            }
        }).orElse(DEFAULT);
        BadSyntax.when((splitters.length() == 0 ? 1 : 0) != 0, (String)"$getsep defines a zero length separator", (Object[])new Object[0]);
        String input = in.toString();
        int index = input.indexOf(splitters.charAt(0));
        BadSyntax.when((index == -1 ? 1 : 0) != 0, (String)"There is no separator '%s' in the input.", (Object[])new Object[]{Character.valueOf(splitters.charAt(0))});
        String indices = input.substring(0, index);
        String table = input.substring(index + 1);
        int[] indexArray = Arrays.stream(indices.trim().split("\\s+")).mapToInt(Integer::parseInt).map(Math::abs).toArray();
        for (int i = 0; i < indexArray.length; ++i) {
            BadSyntax.when((i >= splitters.length() ? 1 : 0) != 0, (String)"There are too many indices to get data from a string table", (Object[])new Object[0]);
            String splitter = splitters.substring(i, i + 1);
            String[] cols = table.split(Pattern.quote(splitter));
            String table_ = table;
            int i_ = i;
            BadSyntax.when((indexArray[i] >= cols.length ? 1 : 0) != 0, () -> String.format("There are only %d columns in the string \"%s\" using the splitter %s and macro 'get' wants to access %d", cols.length, table_, splitter, indexArray[i_]));
            table = cols[indexArray[i]];
        }
        return table;
    }

    public String getId() {
        return "get";
    }
}

