/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Debuggable;
import javax0.jamal.api.Identified;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.api.UserDefinedMacro;
import javax0.jamal.tools.InputHandler;

public class Regex {

    public static class Matcher
    implements Macro {
        public String evaluate(Input in, Processor processor) throws BadSyntax {
            InputHandler.skipWhiteSpaces((Input)in);
            String id = InputHandler.fetchId((Input)in);
            InputHandler.skipWhiteSpaces((Input)in);
            String[] part = InputHandler.getParts((Input)in, (int)2);
            BadSyntax.when((part.length != 2 ? 1 : 0) != 0, (String)"matcher needs exactly 3 parts separated but the input has %d%d", (Object[])new Object[]{part.length, 1});
            Pattern pattern = Pattern.compile(part[0]);
            java.util.regex.Matcher matcher = pattern.matcher(part[1]);
            GroupUserDefinedMacro udm = new GroupUserDefinedMacro(id, matcher);
            processor.define((Identified)udm);
            return "";
        }
    }

    private static class GroupUserDefinedMacro
    implements UserDefinedMacro {
        final String name;
        final java.util.regex.Matcher matcher;

        public Optional<Debuggable.UserDefinedMacro> debuggable() {
            return Optional.empty();
        }

        GroupUserDefinedMacro(String name, java.util.regex.Matcher matcher) {
            this.name = name;
            this.matcher = matcher;
        }

        public String getId() {
            return this.name;
        }

        public String evaluate(String ... parameters) throws BadSyntax {
            BadSyntax.when((parameters.length == 0 ? 1 : 0) != 0, (String)"The generated macro %s needs at least one argument", (Object[])new Object[]{this.name});
            String command = parameters[0].trim();
            String arg = parameters.length > 1 ? parameters[1] : null;
            try {
                switch (command) {
                    case "nr": {
                        return "" + this.matcher.groupCount();
                    }
                    case "groupIndices": {
                        return IntStream.range(1, this.matcher.groupCount() + 1).mapToObj(i -> "" + i).collect(Collectors.joining(","));
                    }
                    case "start": {
                        return arg == null ? "" + this.matcher.start() : "" + this.matcher.start(Integer.parseInt(arg));
                    }
                    case "end": {
                        return arg == null ? "" + this.matcher.end() : "" + this.matcher.end(Integer.parseInt(arg));
                    }
                    case "group": {
                        if (arg == null) {
                            return this.matcher.group();
                        }
                        try {
                            int index = Integer.parseInt(arg);
                            try {
                                return this.matcher.group(index);
                            }
                            catch (IllegalStateException ise) {
                                throw new BadSyntax("The generated macro '" + this.name + "' for 'group' caused exception with the argument '" + index + "'");
                            }
                        }
                        catch (NumberFormatException ignored) {
                            try {
                                return this.matcher.group(arg);
                            }
                            catch (IllegalStateException ise) {
                                throw new BadSyntax("The generated macro '" + this.name + "' for 'group' caused exception with the argument '" + arg + "'");
                            }
                        }
                    }
                    case "matches": {
                        return "" + this.matcher.matches();
                    }
                    case "find": {
                        if (arg == null) {
                            return "" + this.matcher.find();
                        }
                        int start = Integer.parseInt(arg);
                        return "" + this.matcher.find(start);
                    }
                }
                throw new BadSyntax("The generated macro '" + this.name + "' argument '" + command + "' cannot be interpreted.");
            }
            catch (NumberFormatException nfe) {
                throw new BadSyntax("The command '" + command + "' in the generated macro '" + this.name + "' needs a numeric argument");
            }
        }

        public int expectedNumberOfArguments() {
            return -1;
        }
    }

    public static class ReplaceAll
    implements Macro {
        public String evaluate(Input in, Processor processor) throws BadSyntax {
            String[] part = InputHandler.getParts((Input)in);
            BadSyntax.when((part.length != 3 ? 1 : 0) != 0, (String)"replaceAll needs exactly 3 parts separated but the input has %d", (Object[])new Object[]{part.length});
            return part[0].replaceAll(part[1], part[2]);
        }

        public String getId() {
            return "replaceAll";
        }
    }
}

