/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.extensions.UDMacro;
import javax0.jamal.tools.FileTools;
import javax0.jamal.tools.InputHandler;

public class Snippet
implements Macro,
InnerScopeDependent {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        String content;
        String snippetFile = UDMacro.macro("snippetFile").from(processor).orElse(null);
        BadSyntax.when((snippetFile == null ? 1 : 0) != 0, (String)"snippetFile is null", (Object[])new Object[0]);
        String snippetStart = UDMacro.macro("snippetStart").from(processor).orElse("snippet\\s+");
        String snippetEnd = UDMacro.macro("snippetEnd").from(processor).orElse("snippet\\s+end");
        InputHandler.skipWhiteSpaces((Input)in);
        String snippetId = in.toString().trim();
        String reference = in.getReference();
        String fileName = FileTools.absolute((String)reference, (String)snippetFile);
        try (Stream<String> lines = Files.lines(Paths.get(fileName, new String[0]));){
            content = lines.collect(Collectors.joining("\n"));
        }
        catch (IOException ioe) {
            throw new BadSyntax("Snippet file '" + fileName + "' cannot be read.", (Throwable)ioe);
        }
        Pattern start = Pattern.compile(snippetStart + Pattern.quote(snippetId));
        Pattern end = Pattern.compile(snippetEnd);
        Matcher startMatcher = start.matcher(content);
        Matcher endMatcher = end.matcher(content);
        if (startMatcher.find()) {
            int i;
            for (i = startMatcher.end(); i < content.length() && content.charAt(i) != '\n'; ++i) {
            }
            if (i < content.length()) {
                ++i;
            }
            if (endMatcher.find(i)) {
                int j;
                for (j = endMatcher.start(); j > i && content.charAt(j) != '\n'; --j) {
                }
                return content.substring(i, j);
            }
        }
        throw new BadSyntax("There is no snippet named '" + snippetId + "' in the file '" + snippetFile + "'");
    }
}

