/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.extensions.UDMacro;
import javax0.jamal.tools.InputHandler;

public class SnippetMacros {

    public static class Number
    implements Macro,
    InnerScopeDependent {
        public String evaluate(Input in, Processor processor) throws BadSyntax {
            String format = UDMacro.macro("format").from(processor).orElse("%d. ");
            int start = UDMacro.macro("start").integer().from(processor).orElse(1);
            int step = UDMacro.macro("step").integer().from(processor).orElse(1);
            InputHandler.skipWhiteSpaces2EOL((Input)in);
            int i = 0;
            StringBuilder sb = in.getSB();
            int lineNr = start;
            while (i > -1) {
                String formattedNr = String.format(format, lineNr);
                sb.insert(i, formattedNr);
                i += formattedNr.length();
                lineNr += step;
                i = sb.indexOf("\n", i);
                if (i != -1) {
                    ++i;
                }
                if (i < sb.length()) continue;
                break;
            }
            return in.toString();
        }
    }

    public static class Trim
    implements Macro {
        public String evaluate(Input in, Processor processor) {
            InputHandler.skipWhiteSpaces2EOL((Input)in);
            StringBuilder sb = in.getSB();
            int minSpaces = Integer.MAX_VALUE;
            int i = 0;
            while (i < sb.length()) {
                int spaceCount = 0;
                while (i < sb.length() && Character.isWhitespace(sb.charAt(i)) && sb.charAt(1) != '\n') {
                    ++i;
                    ++spaceCount;
                }
                minSpaces = Math.min(minSpaces, spaceCount);
                int index = sb.indexOf("\n", i);
                if (index == -1) break;
                i = index + 1;
            }
            i = 0;
            while (i < sb.length()) {
                sb.delete(i, i + minSpaces);
                int index = sb.indexOf("\n", i);
                if (index == -1) break;
                i = index + 1;
            }
            return sb.toString();
        }
    }
}

