/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.extensions;

import java.util.Optional;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Evaluable;
import javax0.jamal.api.Processor;

public class UDMacro {
    private final String id;

    private UDMacro(String id) {
        this.id = id;
    }

    public static UDMacro macro(String id) {
        return new UDMacro(id);
    }

    public Optional<String> from(Processor processor) throws BadSyntax {
        Optional<Evaluable> evaluable = processor.getRegister().getUserDefined(this.id).filter(macro -> macro instanceof Evaluable).map(macro -> (Evaluable)macro);
        if (evaluable.isPresent()) {
            return Optional.ofNullable(evaluable.get().evaluate(new String[0]));
        }
        return Optional.empty();
    }

    public IntUDMac integer() {
        return new IntUDMac();
    }

    public class IntUDMac {
        public Optional<Integer> from(Processor processor) throws BadSyntax {
            Optional<String> string = UDMacro.this.from(processor);
            if (string.isPresent()) {
                try {
                    return Optional.of(Integer.parseInt(string.get()));
                }
                catch (NumberFormatException nfe) {
                    throw new BadSyntax(UDMacro.this.id + " is not a number");
                }
            }
            return Optional.empty();
        }
    }
}

