/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.jar.input;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax0.jamal.api.ResourceReader;

public class JarInput
implements ResourceReader {
    public static final String PREFIX = "jar:file:";
    private static final int PREFIX_LENGTH = "jar:file:".length();

    public boolean canRead(String fileName) {
        return fileName.startsWith(PREFIX);
    }

    public int fileStart(String fileName) {
        return new ResourceCoordinates((String)fileName).jarFileStart;
    }

    public String read(String fileName) throws IOException {
        return this.read(fileName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String read(String fileName, boolean noCache) throws IOException {
        try {
            ResourceCoordinates coor = new ResourceCoordinates(fileName);
            try (JarFile jarFile = new JarFile(coor.jarFile);){
                JarEntry entry = jarFile.getJarEntry(coor.resourceName);
                if (entry == null) throw new IOException("The file '" + fileName + "' was not found in the JAR archive");
                String string = new String(jarFile.getInputStream(entry).readAllBytes(), StandardCharsets.UTF_8);
                return string;
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static class ResourceCoordinates {
        final String jarFile;
        final String resourceName;
        final int jarFileStart;

        ResourceCoordinates(String url) {
            if (!url.startsWith(JarInput.PREFIX)) {
                throw new IllegalArgumentException(String.format("The JAR resource should start with '%s'", JarInput.PREFIX));
            }
            int jarFileStart = PREFIX_LENGTH;
            int excl = (url = url.substring(jarFileStart)).indexOf(33);
            if (excl < 0) {
                throw new IllegalArgumentException(String.format("The format of a JAR resource is '%spath_to_the_JAR_file!path_inside_the_jar_to_the_file'", JarInput.PREFIX));
            }
            String jarPart = url.substring(0, excl);
            while (jarPart.startsWith("//")) {
                jarPart = jarPart.substring(1);
                ++jarFileStart;
            }
            if (jarPart.length() >= 3 && jarPart.charAt(0) == '/' && Character.isAlphabetic(jarPart.charAt(1)) && jarPart.charAt(2) == ':') {
                ++jarFileStart;
                jarPart = jarPart.substring(1);
            }
            this.jarFile = jarPart;
            this.resourceName = url.substring(excl + 1);
            this.jarFileStart = jarFileStart;
        }
    }
}

