/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.maven.input;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import javax0.jamal.api.EnvironmentVariables;
import javax0.jamal.api.ResourceReader;
import javax0.jamal.tools.FileTools;
import javax0.maventools.download.ArtifactType;
import javax0.maventools.download.Downloader;
import javax0.maventools.download.MavenCoordinates;
import javax0.maventools.download.Pom;
import javax0.maventools.download.Repo;

public class MavenInput
implements ResourceReader {
    private final String PREFIX = "maven:";
    private final int PREFIX_LENGTH = "maven:".length();
    private static final String JAMAL_LOCAL_REPO_ENV = "JAMAL_LOCAL_REPO";
    private static final String JAMAL_REMOTE_REPOS_ENV = "JAMAL_REMOTE_REPOS";
    private static final Path LOCAL_REPO;
    private static final Repo[] REMOTE_REPOS;
    private static final Downloader downloader;

    public boolean canRead(String fileName) {
        return fileName.startsWith("maven:");
    }

    public int fileStart(String fileName) {
        int count = 0;
        for (int i = 0; i < fileName.length(); ++i) {
            if (fileName.charAt(i) != ':' || ++count != 5) continue;
            return i + 1;
        }
        return -1;
    }

    public String read(String fileName) throws IOException {
        return this.read(fileName, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String read(String fileName, boolean noCache) throws IOException {
        try {
            ResourceCoordinates coor = new ResourceCoordinates(fileName);
            Set<Object> classifiers = coor.classifier.length() == 0 ? Set.of() : Arrays.stream(coor.classifier.split(",")).map(c -> Pom.DependencyScope.fromString((String)c.trim())).collect(Collectors.toSet());
            File[] files = classifiers.isEmpty() ? new File[]{new Downloader(LOCAL_REPO, REMOTE_REPOS).download(new MavenCoordinates(coor.groupId, coor.artifactId, coor.version), ArtifactType.JAR)} : new Downloader(LOCAL_REPO, REMOTE_REPOS).fetch(new MavenCoordinates(coor.groupId, coor.artifactId, coor.version), Set.of(ArtifactType.JAR), classifiers);
            File[] fileArray = files;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try (JarFile jarFile = new JarFile(file);){
                    JarEntry entry = jarFile.getJarEntry(coor.fileName);
                    if (entry != null) {
                        String string = new String(jarFile.getInputStream(entry).readAllBytes(), StandardCharsets.UTF_8);
                        return string;
                    }
                }
                ++n2;
            }
            throw new IOException("The file '" + fileName + "' was not found in the Maven archives");
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    static {
        String localRepo = EnvironmentVariables.getenv((String)JAMAL_LOCAL_REPO_ENV).orElse(FileTools.adjustedFileName((String)"~/.m2/repository"));
        LOCAL_REPO = Paths.get(localRepo, new String[0]);
        REMOTE_REPOS = (Repo[])Arrays.stream(EnvironmentVariables.getenv((String)JAMAL_REMOTE_REPOS_ENV).orElse("central").split(",")).map(name -> Arrays.stream(Repo.REPOS).filter(r -> r.name.equals(name)).map(r -> r.url).findFirst().orElse((String)name)).map(name -> new Repo("", name)).toArray(Repo[]::new);
        downloader = new Downloader(LOCAL_REPO, REMOTE_REPOS);
    }

    private static class ResourceCoordinates {
        final String groupId;
        final String artifactId;
        final String version;
        final String classifier;
        final String fileName;

        ResourceCoordinates(String url) {
            String[] parts = url.split(":", 6);
            if (parts.length != 6) {
                throw new IllegalArgumentException("The Maven coordinate must be 'maven:groupId:artifactId:version:classifier:fileName'");
            }
            this.groupId = parts[1].trim();
            this.artifactId = parts[2].trim();
            this.version = parts[3].trim();
            this.classifier = parts[4].trim();
            this.fileName = parts[5].trim();
        }
    }
}

