/*
 * Decompiled with CFR 0.152.
 */
package javax0.jamal.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax0.jamal.api.BadSyntax;
import javax0.jamal.api.Identified;
import javax0.jamal.api.InnerScopeDependent;
import javax0.jamal.api.Input;
import javax0.jamal.api.Macro;
import javax0.jamal.api.Processor;
import javax0.jamal.tools.Cache;
import javax0.jamal.tools.FileTools;
import javax0.jamal.tools.IndexedPlaceHolders;
import javax0.jamal.tools.InputHandler;
import javax0.jamal.tools.Params;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.SourceStringReader;

public class PlantUml
implements Macro,
InnerScopeDependent {
    public String evaluate(Input in, Processor processor) throws BadSyntax {
        Params.Param root = Params.holder((String[])new String[]{"pu$folder", "folder"}).orElse("./");
        Params.Param format = Params.holder((String[])new String[]{"pu$format", "format"}).orElse("SVG");
        Params.Param template = Params.holder((String[])new String[]{"pu$template", "template"}).orElse("$file");
        Params.using((Processor)processor).from((Identified)this).keys(new Params.Param[]{root, format, template}).between("()").parse(in);
        String fileName = InputHandler.fetch2EOL((Input)in).trim();
        Object imageDir = ((String)root.get()).endsWith("/") ? (String)root.get() : (String)root.get() + "/";
        String absoluteFileName = FileTools.absolute((String)in.getReference(), (String)((String)imageDir + fileName));
        InputHandler.skipWhiteSpaces((Input)in);
        String umlText = this.getUmlText(in);
        File output = new File(absoluteFileName).getAbsoluteFile();
        Cache.Entry entry = this.getCacheEntry(output);
        try {
            boolean erred;
            if (this.needPlantUmlRun(umlText, output, entry)) {
                erred = this.convertToFile(umlText, output, (String)format.get());
                if (entry != null) {
                    entry.save(umlText, new Map[]{Map.of("error", "" + erred)});
                }
            } else {
                erred = "true".equals(entry.getProperty("error"));
            }
            BadSyntax.when((boolean)erred, (String)"There was an error processing diagram for '%s' in PlantUml.", (Object[])new Object[]{fileName});
            return Trie.formatter.format((String)template.get(), new String[]{fileName});
        }
        catch (Exception e) {
            throw new BadSyntax("PlantUml diagram '" + fileName + "'cannot be created.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean convertToFile(String text, File file, String format) throws BadSyntax, IOException {
        boolean erred;
        SourceStringReader reader = new SourceStringReader(text);
        FileFormat fileFormat = this.convertFileFormat(format);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String headless = System.getProperty("java.awt.headless");
        try (ByteArrayOutputStream byteArrayOutputStream = os;){
            System.setProperty("java.awt.headless", "true");
            erred = "(Error)".equals(reader.outputImage((OutputStream)os, new FileFormatOption(fileFormat)).getDescription());
        }
        finally {
            if (headless != null) {
                System.setProperty("java.awt.headless", headless);
            } else {
                System.clearProperty("java.awt.headless");
            }
        }
        file.getParentFile().mkdirs();
        try (FileOutputStream fos = new FileOutputStream(file);){
            fos.write(os.toByteArray());
        }
        return erred;
    }

    private boolean needPlantUmlRun(String umlText, File output, Cache.Entry entry) {
        return entry == null || entry.isMiss() || !entry.getContent().toString().equals(umlText) || !output.exists();
    }

    private Cache.Entry getCacheEntry(File output) {
        try {
            return Cache.getEntry((URL)output.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private FileFormat convertFileFormat(String format) throws BadSyntax {
        for (FileFormat fileFormat : FileFormat.values()) {
            if (!format.equals(fileFormat.toString())) continue;
            return fileFormat;
        }
        throw new BadSyntax("The output format '" + format + "' is not supported by PlantUml.");
    }

    private String getUmlText(Input in) {
        Object umlText = in.toString();
        if (((String)umlText).length() > 0 && ((String)umlText).charAt(0) != '@') {
            umlText = "@startuml\n" + (String)umlText + "@enduml\n";
        }
        return umlText;
    }

    private static class Trie {
        static final IndexedPlaceHolders formatter = IndexedPlaceHolders.with((String[])new String[]{"$file"});

        private Trie() {
        }
    }
}

