/*
 * Decompiled with CFR 0.152.
 */
package com.javiersc.kotlin.stdlib.graph;

import com.javiersc.kotlin.stdlib.graph.Graph;
import com.javiersc.kotlin.stdlib.graph.GraphKt;
import com.javiersc.kotlin.stdlib.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\bf\u0018\u0000*\u0004\b\u0000\u0010\u00012 \u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0003\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u00040\u0002:\u00029:J\b\u0010!\u001a\u00020\u001bH\u0016J\u0015\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J)\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00028\u00002\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u0019H\u0016\u00a2\u0006\u0002\u0010&J\u0015\u0010'\u001a\u00020\r2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J\u0015\u0010(\u001a\u00020\r2\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$J#\u0010\u0018\u001a\u00020)2\u0019\u0010*\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001cH\u0016J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J1\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010#\u001a\u00028\u00002\u0014\b\u0002\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\r0\u0019H\u0016\u00a2\u0006\u0002\u0010.J'\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u000000\"\u00028\u0000H\u0016\u00a2\u0006\u0002\u00101JT\u00102\u001a\u00020)*\b\u0012\u0004\u0012\u00028\u00000\u00032\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003042\u0012\u00105\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0003062\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000608H\u0002R&\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\n0\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0012\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R+\u0010\u0018\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001b0\u0019\u00a2\u0006\u0002\b\u001cX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006;"}, d2={"Lcom/javiersc/kotlin/stdlib/graph/Graph;", "T", "", "Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;", "", "Lcom/javiersc/kotlin/stdlib/graph/Graph$Edge;", "circularVertexes", "getCircularVertexes", "()Ljava/util/Map;", "duplicatedVertexes", "", "getDuplicatedVertexes", "hasCircularVertexes", "", "getHasCircularVertexes", "()Z", "hasDuplicatedVertexes", "getHasDuplicatedVertexes", "hasMissingVertexes", "getHasMissingVertexes", "missingVertexes", "", "getMissingVertexes", "()Ljava/util/Set;", "renderer", "Lkotlin/Function1;", "", "", "Lkotlin/ExtensionFunctionType;", "getRenderer", "()Lkotlin/jvm/functions/Function1;", "setRenderer", "(Lkotlin/jvm/functions/Function1;)V", "asString", "contains", "value", "(Ljava/lang/Object;)Z", "predicate", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Z", "containsCircularVertexes", "doesNotContainsCircularVertexes", "", "block", "toGraph", "toGraphSortedByEdges", "vertexesFor", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "values", "", "([Ljava/lang/Object;)Ljava/util/List;", "deepFirstSearchCircularDependencies", "visited", "", "path", "", "circularDependencies", "", "Edge", "Vertex", "kotlin-stdlib"})
public interface Graph<T>
extends Map<Vertex<T>, List<? extends Edge<T>>>,
KMappedMarker {
    @NotNull
    public Function1<Object, String> getRenderer();

    public void setRenderer(@NotNull Function1<Object, String> var1);

    @NotNull
    public Map<T, List<T>> getCircularVertexes();

    public boolean getHasCircularVertexes();

    @NotNull
    public Map<T, Integer> getDuplicatedVertexes();

    public boolean getHasDuplicatedVertexes();

    @NotNull
    public Set<T> getMissingVertexes();

    public boolean getHasMissingVertexes();

    @NotNull
    public String asString();

    public boolean contains(T var1);

    public boolean contains(T var1, @NotNull Function1<? super T, Boolean> var2);

    @NotNull
    public Graph<T> toGraph();

    public boolean containsCircularVertexes(T var1);

    public boolean doesNotContainsCircularVertexes(T var1);

    @NotNull
    public List<T> vertexesFor(T var1, @NotNull Function1<? super T, Boolean> var2);

    @NotNull
    public List<T> vertexesFor(T ... var1);

    @NotNull
    public Graph<T> toGraphSortedByEdges();

    public void renderer(@NotNull Function1<Object, String> var1);

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    @SourceDebugExtension(value={"SMAP\nGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Graph.kt\ncom/javiersc/kotlin/stdlib/graph/Graph$DefaultImpls\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,195:1\n453#2:196\n403#2:197\n494#2,7:203\n372#2,7:229\n1238#3,4:198\n1536#3:202\n1747#3,3:212\n1747#3,3:215\n1549#3:225\n1620#3,3:226\n215#4,2:210\n1#5:218\n9972#6:219\n10394#6,5:220\n*S KotlinDebug\n*F\n+ 1 Graph.kt\ncom/javiersc/kotlin/stdlib/graph/Graph$DefaultImpls\n*L\n19#1:196\n19#1:197\n26#1:203,7\n128#1:229,7\n19#1:198,4\n26#1:202\n44#1:212,3\n47#1:215,3\n126#1:225\n126#1:226,3\n37#1:210,2\n65#1:219\n65#1:220,5\n*E\n"})
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <T> Map<T, List<T>> getCircularVertexes(@NotNull Graph<T> $this) {
            void $this$mapValuesTo$iv$iv;
            Object path;
            Map circularDependencies = new LinkedHashMap();
            Set visited = new LinkedHashSet();
            for (Vertex vertex : $this.keySet()) {
                if (visited.contains(vertex)) continue;
                path = new ArrayList();
                DefaultImpls.deepFirstSearchCircularDependencies($this, vertex, visited, path, circularDependencies);
            }
            Map $this$mapValues$iv = circularDependencies;
            boolean $i$f$mapValues = false;
            path = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map2 = map;
                boolean bl2 = false;
                List list = CollectionsKt.toList((Iterable)((Iterable)it.getValue()));
                map2.put(k, list);
            }
            return destination$iv$iv;
        }

        public static <T> boolean getHasCircularVertexes(@NotNull Graph<T> $this) {
            return !$this.getCircularVertexes().isEmpty();
        }

        @NotNull
        public static <T> Map<T, Integer> getDuplicatedVertexes(@NotNull Graph<T> $this) {
            Iterable $this$groupingBy$iv = $this.keySet();
            boolean $i$f$groupingBy = false;
            Map $this$filterValues$iv = GroupingKt.eachCount((Grouping)new Grouping<Vertex<T>, T>($this$groupingBy$iv){
                final /* synthetic */ Iterable $this_groupingBy;
                {
                    this.$this_groupingBy = $receiver;
                }

                @NotNull
                public Iterator<Vertex<T>> sourceIterator() {
                    return this.$this_groupingBy.iterator();
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object keyOf(Object element) {
                    Vertex p0 = (Vertex)element;
                    boolean bl = false;
                    return p0.getValue();
                }
            });
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl = false;
                if (!(it > 1)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            return result$iv;
        }

        public static <T> boolean getHasDuplicatedVertexes(@NotNull Graph<T> $this) {
            return !$this.getDuplicatedVertexes().isEmpty();
        }

        public static <T> boolean getHasMissingVertexes(@NotNull Graph<T> $this) {
            return !((Collection)$this.getMissingVertexes()).isEmpty();
        }

        @NotNull
        public static <T> String asString(@NotNull Graph<T> $this) {
            StringBuilder stringBuilder;
            StringBuilder $this$asString_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl = false;
            Map $this$forEach$iv = $this;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl2 = false;
                Vertex vertex = (Vertex)entry.getKey();
                List edges = (List)entry.getValue();
                String value = (String)$this.getRenderer().invoke(vertex.getValue());
                String edgeString2 = CollectionsKt.joinToString$default((Iterable)edges, null, null, null, (int)0, null, (Function1)new Function1<Edge<T>, CharSequence>($this){
                    final /* synthetic */ Graph<T> this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@NotNull Edge<T> it) {
                        Intrinsics.checkNotNullParameter(it, (String)"it");
                        return (CharSequence)this.this$0.getRenderer().invoke(it.getDestination().getValue());
                    }
                }, (int)31, null);
                StringBuilder stringBuilder2 = $this$asString_u24lambda_u243.append(value + " -> [" + edgeString2 + ']');
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        public static <T> boolean contains(@NotNull Graph<T> $this, T value) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = $this.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Vertex it = (Vertex)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getValue(), value)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        public static <T> boolean contains(@NotNull Graph<T> $this, T value, @NotNull Function1<? super T, Boolean> predicate) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                Iterable $this$any$iv = $this.keySet();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Vertex it = (Vertex)element$iv;
                        boolean bl2 = false;
                        if (!((Boolean)predicate.invoke(it.getValue())).booleanValue()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public static <T> Graph<T> toGraph(@NotNull Graph<T> $this) {
            return $this;
        }

        public static <T> boolean containsCircularVertexes(@NotNull Graph<T> $this, T value) {
            List<T> list = $this.getCircularVertexes().get(value);
            return list != null ? !((Collection)list).isEmpty() : false;
        }

        public static <T> boolean doesNotContainsCircularVertexes(@NotNull Graph<T> $this, T value) {
            return !$this.containsCircularVertexes(value);
        }

        @NotNull
        public static <T> List<T> vertexesFor(@NotNull Graph<T> $this, T value, @NotNull Function1<? super T, Boolean> predicate) {
            Object v0;
            block4: {
                Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
                if ($this.containsCircularVertexes(value)) {
                    return CollectionsKt.emptyList();
                }
                Iterable iterable = $this.keySet();
                for (Object t : iterable) {
                    Vertex it = (Vertex)t;
                    boolean bl = false;
                    if (!((Boolean)predicate.invoke(it.getValue())).booleanValue()) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            Vertex vertex = v0;
            if (vertex == null) {
                return CollectionsKt.emptyList();
            }
            Vertex vertex2 = vertex;
            List list = (List)$this.get(vertex2);
            if (list == null) {
                return CollectionsKt.emptyList();
            }
            List edges = list;
            Sequence destinationVertexes2 = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)edges), (Function1)((Function1)vertexesFor.destinationVertexes.1.INSTANCE));
            Sequence destinations2 = SequencesKt.map((Sequence)destinationVertexes2, (Function1)((Function1)vertexesFor.destinations.1.INSTANCE));
            return SequencesKt.toList((Sequence)SequencesKt.plus((Sequence)destinations2, (Sequence)SequencesKt.flatMapIterable((Sequence)destinationVertexes2, (Function1)new Function1<Vertex<T>, List<? extends T>>($this){
                final /* synthetic */ Graph<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final List<T> invoke(@NotNull Vertex<T> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    return DefaultImpls.vertexesFor$default(this.this$0, it.getValue(), null, 2, null);
                }
            })));
        }

        public static /* synthetic */ List vertexesFor$default(Graph graph, Object object, Function1 function1, int n, Object object2) {
            if (object2 != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: vertexesFor");
            }
            if ((n & 2) != 0) {
                function1 = new Function1<T, Boolean>(object){
                    final /* synthetic */ T $value;
                    {
                        this.$value = $value;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(T it) {
                        return Intrinsics.areEqual(it, this.$value);
                    }
                };
            }
            return graph.vertexesFor(object, function1);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public static <T> List<T> vertexesFor(@NotNull Graph<T> $this, T ... values) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter(values, (String)"values");
            T[] $this$flatMap$iv = values;
            boolean $i$f$flatMap = false;
            T[] TArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void p0 = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable list$iv$iv = DefaultImpls.vertexesFor$default($this, p0, null, 2, null);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public static <T> Graph<T> toGraphSortedByEdges(@NotNull Graph<T> $this) {
            return GraphKt.buildGraph((Function1)new Function1<MutableGraph<T>, Unit>($this){
                final /* synthetic */ Graph<T> this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull MutableGraph<T> $this$buildGraph) {
                    Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                    MutableGraph<T> sortedGraph = $this$buildGraph;
                    Graph<T> graph = this.this$0;
                    Map remainingMap = MapsKt.toMutableMap((Map)graph);
                    while (!remainingMap.isEmpty()) {
                        List vertexesToBeRemoved = new ArrayList<E>();
                        for (Map.Entry<K, V> entry : remainingMap.entrySet()) {
                            Vertex vertex = (Vertex)entry.getKey();
                            List edges = (List)entry.getValue();
                            if (edges.isEmpty()) {
                                sortedGraph.addVertex(vertex.getValue());
                                vertexesToBeRemoved.add(vertex);
                                System.out.println();
                            }
                            for (Edge edge : edges) {
                                void $this$mapTo$iv$iv;
                                Iterable $this$map$iv = sortedGraph.keySet();
                                boolean $i$f$map = false;
                                Iterable iterable = $this$map$iv;
                                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                boolean $i$f$mapTo = false;
                                for (T item$iv$iv : $this$mapTo$iv$iv) {
                                    void p0;
                                    Vertex vertex2 = (Vertex)item$iv$iv;
                                    Collection collection = destination$iv$iv;
                                    boolean bl = false;
                                    collection.add(p0.getValue());
                                }
                                if (!((List)destination$iv$iv).contains(edge.getDestination().getValue())) continue;
                                sortedGraph.addVertex(edge.getSource().getValue());
                                sortedGraph.addEdge(edge.getSource().getValue(), edge.getDestination().getValue());
                                vertexesToBeRemoved.add(edge.getSource());
                                System.out.println();
                            }
                        }
                        for (Vertex vertexToBeRemoved : vertexesToBeRemoved) {
                            remainingMap.remove(vertexToBeRemoved);
                        }
                        vertexesToBeRemoved.clear();
                    }
                }
            });
        }

        public static <T> void renderer(@NotNull Graph<T> $this, @NotNull Function1<Object, String> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            $this.setRenderer(block);
        }

        /*
         * WARNING - void declaration
         */
        private static <T> void deepFirstSearchCircularDependencies(Graph<T> $this, Vertex<T> $receiver, Set<Vertex<T>> visited, List<Vertex<T>> path, Map<T, List<T>> circularDependencies) {
            Graph<T> map = $this;
            Vertex<T> vertex = $receiver;
            visited.add(vertex);
            path.add(vertex);
            List list = (List)map.get(vertex);
            if (list == null) {
                return;
            }
            List edges = list;
            for (Edge edge : edges) {
                Vertex destination = edge.getDestination();
                if (path.contains(destination)) {
                    Object object;
                    void $this$getOrPut$iv;
                    void $this$mapTo$iv$iv;
                    Object $this$map$iv = path.subList(path.indexOf(destination), path.size());
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Vertex vertex2 = (Vertex)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(it.getValue());
                    }
                    List circularDependency = (List)destination$iv$iv;
                    $this$map$iv = circularDependencies;
                    Object key$iv = CollectionsKt.first((List)circularDependency);
                    boolean $i$f$getOrPut = false;
                    Object value$iv = $this$getOrPut$iv.get(key$iv);
                    if (value$iv == null) {
                        boolean bl = false;
                        List answer$iv = new ArrayList();
                        $this$getOrPut$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    ((List)object).addAll(circularDependency);
                    continue;
                }
                if (visited.contains(destination)) continue;
                DefaultImpls.deepFirstSearchCircularDependencies($this, destination, visited, path, circularDependencies);
            }
            if (Intrinsics.areEqual((Object)CollectionsKt.last(path), vertex)) {
                path.remove(vertex);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0002\u0010\u0006J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003J/\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/javiersc/kotlin/stdlib/graph/Graph$Edge;", "T", "", "source", "Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;", "destination", "(Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;)V", "getDestination", "()Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;", "getSource", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "kotlin-stdlib"})
    public static final class Edge<T> {
        @NotNull
        private final Vertex<T> source;
        @NotNull
        private final Vertex<T> destination;

        public Edge(@NotNull Vertex<T> source, @NotNull Vertex<T> destination) {
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            this.source = source;
            this.destination = destination;
        }

        @NotNull
        public final Vertex<T> getSource() {
            return this.source;
        }

        @NotNull
        public final Vertex<T> getDestination() {
            return this.destination;
        }

        @NotNull
        public final Vertex<T> component1() {
            return this.source;
        }

        @NotNull
        public final Vertex<T> component2() {
            return this.destination;
        }

        @NotNull
        public final Edge<T> copy(@NotNull Vertex<T> source, @NotNull Vertex<T> destination) {
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Intrinsics.checkNotNullParameter(destination, (String)"destination");
            return new Edge<T>(source, destination);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, Vertex vertex, Vertex vertex2, int n, Object object) {
            if ((n & 1) != 0) {
                vertex = edge.source;
            }
            if ((n & 2) != 0) {
                vertex2 = edge.destination;
            }
            return edge.copy(vertex, vertex2);
        }

        @NotNull
        public String toString() {
            return "Edge(source=" + this.source + ", destination=" + this.destination + ')';
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = result * 31 + this.destination.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (!Intrinsics.areEqual(this.source, edge.source)) {
                return false;
            }
            return Intrinsics.areEqual(this.destination, edge.destination);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0006J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\u000e\u0010\r\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ(\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0004H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0005\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;", "T", "", "index", "", "value", "(ILjava/lang/Object;)V", "getIndex", "()I", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "copy", "(ILjava/lang/Object;)Lcom/javiersc/kotlin/stdlib/graph/Graph$Vertex;", "equals", "", "other", "hashCode", "toString", "", "kotlin-stdlib"})
    public static final class Vertex<T> {
        private final int index;
        private final T value;

        public Vertex(int index, T value) {
            this.index = index;
            this.value = value;
        }

        public final int getIndex() {
            return this.index;
        }

        public final T getValue() {
            return this.value;
        }

        public final int component1() {
            return this.index;
        }

        public final T component2() {
            return this.value;
        }

        @NotNull
        public final Vertex<T> copy(int index, T value) {
            return new Vertex<T>(index, value);
        }

        public static /* synthetic */ Vertex copy$default(Vertex vertex, int n, Object object, int n2, Object object2) {
            if ((n2 & 1) != 0) {
                n = vertex.index;
            }
            if ((n2 & 2) != 0) {
                object = vertex.value;
            }
            return vertex.copy(n, object);
        }

        @NotNull
        public String toString() {
            return "Vertex(index=" + this.index + ", value=" + this.value + ')';
        }

        public int hashCode() {
            int result = Integer.hashCode(this.index);
            result = result * 31 + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Vertex)) {
                return false;
            }
            Vertex vertex = (Vertex)other;
            if (this.index != vertex.index) {
                return false;
            }
            return Intrinsics.areEqual(this.value, vertex.value);
        }
    }
}

