/*
 * Decompiled with CFR 0.152.
 */
package com.javiersc.logger.internal;

import com.javiersc.logger.LoggerBackgroundColor;
import com.javiersc.logger.LoggerForegroundColor;
import com.javiersc.logger.internal.Level;
import com.javiersc.logger.internal.LoggerNamesKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001H\u0002\u001a2\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"SeparatorSymbol", "", "SeparatorSymbolStart", "coloredPrint", "", "colors", "message", "print", "tag", "", "level", "Lcom/javiersc/logger/internal/Level;", "background", "Lcom/javiersc/logger/LoggerBackgroundColor;", "foreground", "Lcom/javiersc/logger/LoggerForegroundColor;", "logger"})
public final class LoggerPrinterKt {
    @NotNull
    public static final String SeparatorSymbolStart = "\u251c";
    private static final String SeparatorSymbol = "\u2500";

    public static final void print(@Nullable String tag, @NotNull Object message, @NotNull Level level, @NotNull LoggerBackgroundColor background, @NotNull LoggerForegroundColor foreground) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)background), (String)"background");
        Intrinsics.checkNotNullParameter((Object)((Object)foreground), (String)"foreground");
        String tagToPrint = tag != null ? tag + " | " : "";
        List messageLines = StringsKt.lines((CharSequence)message.toString());
        String colors = background.getValue() + foreground.getValue();
        String header = tagToPrint + (Object)((Object)level) + '.' + LoggerNamesKt.getFileLink() + " \u2502 " + LoggerNamesKt.getFileName() + " \u2502 " + LoggerNamesKt.getClassName() + " \u2502 " + LoggerNamesKt.getMethodName() + " \u2502 " + LoggerNamesKt.getLineNumber();
        Iterable iterable = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)header), (Iterable)messageLines);
        boolean bl = false;
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw (Throwable)new NoSuchElementException();
        }
        Object receiver = iterator.next();
        boolean bl2 = false;
        int n = ((String)receiver).length();
        while (iterator.hasNext()) {
            Object receiver22 = iterator.next();
            $i$a$-unknown-Object = false;
            int receiver22 = ((String)receiver22).length();
            if (n >= receiver22) continue;
            n = receiver22;
        }
        int maxLineSize = n;
        String internalSeparator = StringsKt.repeat((CharSequence)SeparatorSymbol, (int)(maxLineSize + 2));
        LoggerPrinterKt.coloredPrint(colors, " \u250c" + internalSeparator + "\u2510 ");
        LoggerPrinterKt.coloredPrint(colors, " \u2502 " + header + " \u2502 ");
        LoggerPrinterKt.coloredPrint(colors, " \u251c" + internalSeparator + "\u2524 ");
        Iterable $this$forEach$iv = messageLines;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl3 = false;
            if (StringsKt.startsWith$default((String)line, (String)SeparatorSymbolStart, (boolean)false, (int)2, null)) {
                LoggerPrinterKt.coloredPrint(colors, " \u251c" + internalSeparator + "\u2502 ");
                continue;
            }
            LoggerPrinterKt.coloredPrint(colors, " \u2502 " + line + StringsKt.repeat((CharSequence)" ", (int)(maxLineSize - line.length())) + " \u2502 ");
        }
        LoggerPrinterKt.coloredPrint(colors, " \u2514" + internalSeparator + "\u2518 ");
    }

    private static final void coloredPrint(String colors, String message) {
        String resetColors = LoggerForegroundColor.Reset.getValue();
        String string = colors + message + resetColors;
        boolean bl = false;
        System.out.println((Object)string);
    }
}

