/*
 * Decompiled with CFR 0.152.
 */
package com.javiersc.gradle.version;

import com.javiersc.gradle.version.GradleVersion;
import com.javiersc.gradle.version.GradleVersionException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0000\u001a*\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0082\b\u0082\u0002\b\n\u0006\b\u0000\u001a\u0002\u0010\u0001\u001aY\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00132\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00132\b\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u001b\u001a)\u0010\u001c\u001a\u00020\u0003*\u00060\u001dj\u0002`\u001e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u001f\"\u000e\u0010 \u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010!\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"red", "", "checkSignificantVersion", "", "version", "checkInsignificantVersion", "checkStage", "stage", "gradleVersionError", "", "message", "checkVersion", "value", "", "lazyMessage", "Lkotlin/Function0;", "", "buildVersion", "major", "", "minor", "patch", "stageName", "stageNum", "commits", "hash", "metadata", "(IILjava/lang/Integer;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/String;", "appendStage", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Ljava/lang/StringBuilder;Ljava/lang/String;Ljava/lang/Integer;)V", "RED", "RESET", "gradle-version"})
@SourceDebugExtension(value={"SMAP\nGradleVersion.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleVersion.kt\ncom/javiersc/gradle/version/GradleVersionKt\n+ 2 Strings.kt\ncom/javiersc/kotlin/stdlib/StringsKt\n*L\n1#1,710:1\n663#1,2:711\n663#1,2:713\n663#1,2:715\n51#2,2:717\n*S KotlinDebug\n*F\n+ 1 GradleVersion.kt\ncom/javiersc/gradle/version/GradleVersionKt\n*L\n571#1:711,2\n602#1:713,2\n641#1:715,2\n702#1:717,2\n*E\n"})
public final class GradleVersionKt {
    @NotNull
    private static final String RED = "\u001b[31m";
    @NotNull
    private static final String RESET = "\u001b[0m";

    private static final String red(String $this$red) {
        return RED + $this$red + RESET;
    }

    private static final void checkSignificantVersion(String version) {
        CharSequence charSequence = version;
        boolean value$iv = GradleVersion.Companion.getSignificantRegex().matches(charSequence);
        boolean $i$f$checkVersion = false;
        if (!value$iv) {
            boolean bl = false;
            GradleVersionKt.gradleVersionError(GradleVersionKt.red(StringsKt.trimMargin$default((String)("|The version is not semantic and significant, rules:\n           |  - `major`, `minor` and `patch` are required, separated by `.`\n           |  - `stage` and `num` are required if one of them is present, except for snapshots\n           |    - `stage` follows `-`\n           |    - `num` follows `.`\n           |  - `commits number` and `hash` are required if one of them is present\n           |    - `commits number` follows `.`\n           |    - `hash` follows `+`\n           |  - `metadata` is optional, it follows `+`\n           |\n           |Valid version: <major>.<minor>.<patch>[-<stage>.<num>][.<commits number>+<hash>][+<metadata>]\n           |\n           |Current version: " + version + "\n           |\n           |Samples of semantic versions:\n           |`1.0.0` // scope\n           |`1.0-alpha.1` // scope + stage\n           |`1.0.0-SNAPSHOT` // scope + stage\n           |`1.0.0-alpha.1` // scope + stage\n           |`12.23.34-alpha.45` // scope + stage\n           |`12.23.34-SNAPSHOT` // scope + stage\n           |`1.0.0+M3T4D4T4` // scope + metadata\n           |\n        "), null, (int)1, null)).toString());
            throw new KotlinNothingValueException();
        }
    }

    private static final void checkInsignificantVersion(String version) {
        CharSequence charSequence = version;
        boolean value$iv = GradleVersion.Companion.getInsignificantRegex().matches(charSequence);
        boolean $i$f$checkVersion = false;
        if (!value$iv) {
            boolean bl = false;
            GradleVersionKt.gradleVersionError(GradleVersionKt.red(StringsKt.trimMargin$default((String)("|The version is not semantic and insignificant, rules:\n           |  - `major`, `minor` and `patch` are required, separated by `.`\n           |  - `stage` and `num` are required if one of them is present, except for snapshots\n           |    - `stage` follows `-`\n           |    - `num` follows `.`\n           |  - `commits number` and `hash` are required if one of them is present\n           |    - `commits number` follows `.`\n           |    - `hash` follows `+`\n           |  - `metadata` is optional, it follows `+`\n           |\n           |Valid version: <major>.<minor>.<patch>[-<stage>.<num>][.<commits number>+<hash>][+<metadata>]\n           |\n           |Current version: " + version + "\n           |\n           |Samples of semantic versions:\n           |`1.0.0` // scope\n           |`1.0-alpha.1` // scope + stage\n           |`1.0.0-SNAPSHOT` // scope + stage\n           |`1.0.0-alpha.1` // scope + stage\n           |`12.23.34-alpha.45` // scope + stage\n           |`12.23.34-SNAPSHOT` // scope + stage\n           |`1.0.0+M3T4D4T4` // scope + metadata\n           |`1.0.0.10+H4SH345` // scope + commits + hash\n           |`1.0.0.10+DIRTY` // scope + commits + dirty\n           |`1.0.0-alpha.1.10+H4SH345` // scope + stage + hash + dirty\n           |`1.0.0-alpha.1.10+DIRTY` // scope + stage + commits + dirty\n           |`1.0.0.10+H4SH345+M3T4D4T4` // scope + commits + hash + metadata\n           |`1.0.0.10+DIRTY+M3T4D4T4` // scope + commits + dirty + metadata\n           |`1.0.0-alpha.1.10+H4SH345+M3T4D4T4` // scope + stage + hash + dirty + metadata\n           |`1.0.0-alpha.1.10+DIRTY+M3T4D4T4` // scope + stage + commits + dirty + metadata\n           |\n        "), null, (int)1, null)).toString());
            throw new KotlinNothingValueException();
        }
    }

    private static final void checkStage(String stage) {
        CharSequence charSequence = stage;
        boolean value$iv = GradleVersion.Companion.getStageRegex().matches(charSequence);
        boolean $i$f$checkVersion = false;
        if (!value$iv) {
            boolean bl = false;
            GradleVersionKt.gradleVersionError(GradleVersionKt.red(StringsKt.trimMargin$default((String)("|`stage` provided has an incorrect format\n           |\n           |Current stage: " + stage + "\n           |\n           |Samples of stages:\n           |alpha.1\n           |beta.23\n           |SNAPSHOT\n        "), null, (int)1, null)).toString());
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public static final Void gradleVersionError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        throw new GradleVersionException(message);
    }

    private static final void checkVersion(boolean value, Function0<? extends Object> lazyMessage) {
        boolean $i$f$checkVersion = false;
        if (!value) {
            GradleVersionKt.gradleVersionError(lazyMessage.invoke().toString());
            throw new KotlinNothingValueException();
        }
    }

    private static final String buildVersion(int major, int minor, Integer patch, String stageName, Integer stageNum, Integer commits, String hash, String metadata) {
        StringBuilder stringBuilder;
        StringBuilder $this$buildVersion_u24lambda_u243 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildVersion_u24lambda_u243.append(major);
        $this$buildVersion_u24lambda_u243.append(".");
        $this$buildVersion_u24lambda_u243.append(minor);
        $this$buildVersion_u24lambda_u243.append(".");
        $this$buildVersion_u24lambda_u243.append(patch);
        if (!StringsKt.equals((String)stageName, (String)"SNAPSHOT", (boolean)true)) {
            GradleVersionKt.appendStage($this$buildVersion_u24lambda_u243, stageName, stageNum);
        }
        if (commits != null) {
            $this$buildVersion_u24lambda_u243.append(".");
            $this$buildVersion_u24lambda_u243.append(commits);
        }
        if (hash != null) {
            $this$buildVersion_u24lambda_u243.append("+");
            $this$buildVersion_u24lambda_u243.append(hash);
        }
        if (metadata != null) {
            $this$buildVersion_u24lambda_u243.append("+");
            $this$buildVersion_u24lambda_u243.append(metadata);
        }
        if (StringsKt.equals((String)stageName, (String)"SNAPSHOT", (boolean)true)) {
            GradleVersionKt.appendStage($this$buildVersion_u24lambda_u243, stageName, stageNum);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void appendStage(StringBuilder $this$appendStage, String stageName, Integer stageNum) {
        String $this$isNotNullNorBlank$iv = stageName;
        boolean $i$f$isNotNullNorBlank = false;
        CharSequence charSequence = $this$isNotNullNorBlank$iv;
        boolean bl = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence));
        if (bl) {
            $this$appendStage.append("-");
            $this$appendStage.append(GradleVersion.Stage.Companion.invoke(stageName, stageNum).toString());
        }
    }

    public static final /* synthetic */ void access$checkSignificantVersion(String version) {
        GradleVersionKt.checkSignificantVersion(version);
    }

    public static final /* synthetic */ void access$checkInsignificantVersion(String version) {
        GradleVersionKt.checkInsignificantVersion(version);
    }

    public static final /* synthetic */ String access$buildVersion(int major, int minor, Integer patch, String stageName, Integer stageNum, Integer commits, String hash, String metadata) {
        return GradleVersionKt.buildVersion(major, minor, patch, stageName, stageNum, commits, hash, metadata);
    }

    public static final /* synthetic */ void access$checkStage(String stage) {
        GradleVersionKt.checkStage(stage);
    }
}

