/*
 * Decompiled with CFR 0.152.
 */
package com.javiersc.semver.gradle.plugin.services;

import com.javiersc.semver.gradle.plugin.internal.SemVerMessagesKt;
import com.javiersc.semver.gradle.plugin.internal.SemverPropertiesKt;
import com.javiersc.semver.gradle.plugin.internal.git.GitCache;
import com.javiersc.semver.gradle.plugin.services.GitBuildServiceKt;
import java.io.File;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b \u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u001b\u001cB\u000f\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J%\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0018J%\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/javiersc/semver/gradle/plugin/services/GitBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/javiersc/semver/gradle/plugin/services/GitBuildService$Params;", "Ljava/lang/AutoCloseable;", "execOperations", "Lorg/gradle/process/ExecOperations;", "(Lorg/gradle/process/ExecOperations;)V", "git", "Lorg/eclipse/jgit/api/Git;", "gitCache", "Lcom/javiersc/semver/gradle/plugin/internal/git/GitCache;", "getGitCache$semver_gradle_plugin", "()Lcom/javiersc/semver/gradle/plugin/internal/git/GitCache;", "gitDir", "Ljava/io/File;", "isCreatingTag", "", "close", "", "createTag", "tagPrefixProperty", "", "projectTagPrefix", "version", "createTag$semver_gradle_plugin", "pushTag", "pushTag$semver_gradle_plugin", "Companion", "Params", "semver-gradle-plugin"})
public abstract class GitBuildService
implements BuildService<Params>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    private boolean isCreatingTag;
    @NotNull
    private final File gitDir;
    @NotNull
    private final Git git;
    @NotNull
    private final GitCache gitCache;

    /*
     * WARNING - void declaration
     */
    @Inject
    public GitBuildService(@NotNull ExecOperations execOperations) {
        void it;
        Git git;
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        RegularFile regularFile = (RegularFile)((Params)this.getParameters()).getGitDirectory().getOrNull();
        File file = regularFile != null ? regularFile.getAsFile() : null;
        if (file == null) {
            GitBuildService gitBuildService = this;
            boolean $i$a$-checkNotNull-GitBuildService$gitDir$22 = false;
            SemVerMessagesKt.semverWarningMessage$default("semver plugin can't work if there is no git repository", null, 2, null);
            GitBuildService gitBuildService2 = gitBuildService;
            Unit $i$a$-checkNotNull-GitBuildService$gitDir$22 = Unit.INSTANCE;
            throw new IllegalStateException($i$a$-checkNotNull-GitBuildService$gitDir$22.toString());
        }
        this.gitDir = file;
        Git $i$a$-checkNotNull-GitBuildService$gitDir$22 = git = new Git(((FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().setGitDir(this.gitDir)).readEnvironment()).findGitDir()).build());
        GitBuildService gitBuildService = this;
        boolean bl = false;
        if (!GitBuildServiceKt.access$hasCommits((Git)it)) {
            SemVerMessagesKt.semverWarningMessage$default("semver plugin can't work if there are no commits", null, 2, null);
        }
        gitBuildService.git = git;
        this.gitCache = new GitCache(this.git);
    }

    @NotNull
    public final GitCache getGitCache$semver_gradle_plugin() {
        return this.gitCache;
    }

    public final void createTag$semver_gradle_plugin(@NotNull String tagPrefixProperty, @NotNull String projectTagPrefix, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)tagPrefixProperty, (String)"tagPrefixProperty");
        Intrinsics.checkNotNullParameter((Object)projectTagPrefix, (String)"projectTagPrefix");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.isCreatingTag && Intrinsics.areEqual((Object)projectTagPrefix, (Object)tagPrefixProperty)) {
            this.isCreatingTag = true;
            if (!this.git.status().call().isClean()) {
                boolean bl = false;
                String string = "A semver tag can't be created if the repo is not clean";
                throw new IllegalStateException(string.toString());
            }
            String semverWithTagPrefix = projectTagPrefix + version;
            this.git.tag().setName(semverWithTagPrefix).call();
            SemVerMessagesKt.semverMessage$default("Created new semver tag: " + semverWithTagPrefix, null, 2, null);
        }
    }

    public final void pushTag$semver_gradle_plugin(@NotNull String tagPrefixProperty, @NotNull String projectTagPrefix, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)tagPrefixProperty, (String)"tagPrefixProperty");
        Intrinsics.checkNotNullParameter((Object)projectTagPrefix, (String)"projectTagPrefix");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.isCreatingTag && Intrinsics.areEqual((Object)tagPrefixProperty, (Object)projectTagPrefix)) {
            this.createTag$semver_gradle_plugin(tagPrefixProperty, projectTagPrefix, version);
            this.execOperations.exec(arg_0 -> GitBuildService.pushTag$lambda$3((Function1)new Function1<ExecSpec, Unit>(this, projectTagPrefix, version){
                final /* synthetic */ GitBuildService this$0;
                final /* synthetic */ String $projectTagPrefix;
                final /* synthetic */ String $version;
                {
                    this.this$0 = $receiver;
                    this.$projectTagPrefix = $projectTagPrefix;
                    this.$version = $version;
                    super(1);
                }

                public final void invoke(ExecSpec exec) {
                    String semverWithTagPrefix;
                    String remote;
                    String string;
                    String remoteProp = (String)((Params)this.this$0.getParameters()).getRemoteProperty().getOrNull();
                    if (remoteProp != null) {
                        Object v0;
                        block5: {
                            Iterable $this$firstOrNull$iv = GitBuildServiceKt.access$getRemotes(GitBuildService.access$getGit$p(this.this$0));
                            boolean $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                String it = (String)element$iv;
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it, (Object)remoteProp)) continue;
                                v0 = element$iv;
                                break block5;
                            }
                            v0 = null;
                        }
                        if (v0 == null) {
                            boolean $i$a$-checkNotNull-GitBuildService$pushTag$1$remote$32 = false;
                            String $i$a$-checkNotNull-GitBuildService$pushTag$1$remote$32 = "There is no remote with the name " + remoteProp;
                            throw new IllegalStateException($i$a$-checkNotNull-GitBuildService$pushTag$1$remote$32.toString());
                        }
                        string = v0;
                    } else {
                        string = GitBuildServiceKt.access$getRemotes(GitBuildService.access$getGit$p(this.this$0)).contains("origin") ? "origin" : (String)CollectionsKt.firstOrNull((List)GitBuildServiceKt.access$getRemotes(GitBuildService.access$getGit$p(this.this$0)));
                    }
                    if ((remote = string) == null) {
                        boolean $i$a$-checkNotNull-GitBuildService$pushTag$1$22 = false;
                        String $i$a$-checkNotNull-GitBuildService$pushTag$1$22 = "There is no remote repositories";
                        throw new IllegalStateException($i$a$-checkNotNull-GitBuildService$pushTag$1$22.toString());
                    }
                    String tag = semverWithTagPrefix = this.$projectTagPrefix + this.$version;
                    Object[] objectArray = new Object[]{"git", "push", remote, tag};
                    exec.commandLine(objectArray);
                }
            }, arg_0));
        }
    }

    @Override
    public void close() {
        this.isCreatingTag = false;
    }

    private static final void pushTag$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ Git access$getGit$p(GitBuildService $this) {
        return $this.git;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/javiersc/semver/gradle/plugin/services/GitBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "gitDirectory", "Lorg/gradle/api/file/RegularFileProperty;", "getGitDirectory", "()Lorg/gradle/api/file/RegularFileProperty;", "remoteProperty", "Lorg/gradle/api/provider/Property;", "", "getRemoteProperty", "()Lorg/gradle/api/provider/Property;", "semver-gradle-plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getGitDirectory();

        @NotNull
        public Property<String> getRemoteProperty();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/javiersc/semver/gradle/plugin/services/GitBuildService$Companion;", "", "()V", "register", "Lorg/gradle/api/provider/Provider;", "Lcom/javiersc/semver/gradle/plugin/services/GitBuildService;", "project", "Lorg/gradle/api/Project;", "register$semver_gradle_plugin", "semver-gradle-plugin"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Provider<GitBuildService> register$semver_gradle_plugin(@NotNull Project project) {
            void configureAction$iv;
            void implementationType$iv;
            void name$iv;
            void $this$registerIfAbsent$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildServiceRegistry buildServiceRegistry = project.getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"project.gradle.sharedServices");
            BuildServiceRegistry buildServiceRegistry2 = buildServiceRegistry;
            String string = "gitTagBuildService";
            Class<GitBuildService> clazz = GitBuildService.class;
            Action action = arg_0 -> Companion.register$lambda$0((Function1)new Function1<BuildServiceSpec<Params>, Unit>(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                    super(1);
                }

                public final void invoke(BuildServiceSpec<Params> buildService) {
                    ((Params)buildService.getParameters()).getGitDirectory().set(GitBuildServiceKt.access$getGitDir(this.$project));
                    ((Params)buildService.getParameters()).getRemoteProperty().set((Object)SemverPropertiesKt.getRemoteProperty(this.$project));
                    buildService.getMaxParallelUsages().set((Object)1);
                }
            }, arg_0);
            boolean $i$f$registerIfAbsent = false;
            Provider provider = $this$registerIfAbsent$iv.registerIfAbsent((String)name$iv, (Class)implementationType$iv, (Action)configureAction$iv);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"`registerIfAbsent`(`name\u2026.java, `configureAction`)");
            return provider;
        }

        private static final void register$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

