/*
 * Decompiled with CFR 0.152.
 */
package com.javiersc.semver.project.gradle.plugin.services;

import com.javiersc.semver.project.gradle.plugin.SemverExtensionKt;
import com.javiersc.semver.project.gradle.plugin.internal.SemVerMessagesKt;
import com.javiersc.semver.project.gradle.plugin.internal.SemverPropertyKt;
import com.javiersc.semver.project.gradle.plugin.internal.git.GitCache;
import com.javiersc.semver.project.gradle.plugin.services.GitBuildServiceKt;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.jgit.api.Git;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.services.BuildServiceSpec;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecSpec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0002\u0018\u0019B\u0011\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0014J%\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/javiersc/semver/project/gradle/plugin/services/GitBuildService;", "Lorg/gradle/api/services/BuildService;", "Lcom/javiersc/semver/project/gradle/plugin/services/GitBuildService$Params;", "Ljava/lang/AutoCloseable;", "execOperations", "Lorg/gradle/process/ExecOperations;", "<init>", "(Lorg/gradle/process/ExecOperations;)V", "createdTagPrefixes", "", "", "git", "Lorg/eclipse/jgit/api/Git;", "getGit", "()Lorg/eclipse/jgit/api/Git;", "createTag", "", "tagPrefixProperty", "projectTagPrefix", "version", "createTag$semver_project_gradle_plugin", "pushTag", "pushTag$semver_project_gradle_plugin", "close", "Params", "Companion", "semver-project-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGitBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBuildService.kt\ncom/javiersc/semver/project/gradle/plugin/services/GitBuildService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n288#2,2:115\n1#3:117\n*S KotlinDebug\n*F\n+ 1 GitBuildService.kt\ncom/javiersc/semver/project/gradle/plugin/services/GitBuildService\n*L\n59#1:115,2\n*E\n"})
public abstract class GitBuildService
implements BuildService<Params>,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecOperations execOperations;
    @NotNull
    private final Set<String> createdTagPrefixes;

    @Inject
    public GitBuildService(@NotNull ExecOperations execOperations) {
        Intrinsics.checkNotNullParameter((Object)execOperations, (String)"execOperations");
        this.execOperations = execOperations;
        this.createdTagPrefixes = new LinkedHashSet();
    }

    private final Git getGit() {
        Params $this$_get_git__u24lambda_u240 = (Params)this.getParameters();
        boolean bl = false;
        File file = ((RegularFile)$this$_get_git__u24lambda_u240.getGitDir().get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getAsFile(...)");
        return GitCache.Companion.invoke$semver_project_gradle_plugin(file, (Provider<Integer>)((Provider)$this$_get_git__u24lambda_u240.getCommitsMaxCount())).getGit$semver_project_gradle_plugin();
    }

    public final void createTag$semver_project_gradle_plugin(@NotNull String tagPrefixProperty, @NotNull String projectTagPrefix, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)tagPrefixProperty, (String)"tagPrefixProperty");
        Intrinsics.checkNotNullParameter((Object)projectTagPrefix, (String)"projectTagPrefix");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.createdTagPrefixes.contains(tagPrefixProperty) && Intrinsics.areEqual((Object)projectTagPrefix, (Object)tagPrefixProperty)) {
            this.createdTagPrefixes.add(tagPrefixProperty);
            if (!this.getGit().status().call().isClean()) {
                boolean bl = false;
                String string = "A semver tag can't be created if the repo is not clean";
                throw new IllegalStateException(string.toString());
            }
            String semverWithTagPrefix = projectTagPrefix + version;
            this.getGit().tag().setName(semverWithTagPrefix).call();
            SemVerMessagesKt.semverMessage$default("Created new semver tag: " + semverWithTagPrefix, null, 2, null);
        }
    }

    public final void pushTag$semver_project_gradle_plugin(@NotNull String tagPrefixProperty, @NotNull String projectTagPrefix, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)tagPrefixProperty, (String)"tagPrefixProperty");
        Intrinsics.checkNotNullParameter((Object)projectTagPrefix, (String)"projectTagPrefix");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (!this.createdTagPrefixes.contains(tagPrefixProperty) && Intrinsics.areEqual((Object)projectTagPrefix, (Object)tagPrefixProperty)) {
            this.createTag$semver_project_gradle_plugin(tagPrefixProperty, projectTagPrefix, version);
            this.execOperations.exec(arg_0 -> GitBuildService.pushTag$lambda$6(arg_0 -> GitBuildService.pushTag$lambda$5(this, projectTagPrefix, version, arg_0), arg_0));
        }
    }

    @Override
    public void close() {
        this.createdTagPrefixes.clear();
    }

    private static final Unit pushTag$lambda$5(GitBuildService this$0, String $projectTagPrefix, String $version, ExecSpec exec) {
        String remote;
        String string;
        String remoteProp = (String)((Params)this$0.getParameters()).getRemoteProperty().getOrNull();
        if (remoteProp != null) {
            Object v0;
            block5: {
                Iterable $this$firstOrNull$iv = GitBuildServiceKt.access$getRemotes(this$0.getGit());
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it, (Object)remoteProp)) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            if (v0 == null) {
                boolean bl = false;
                String string2 = "There is no remote with the name " + remoteProp;
                throw new IllegalStateException(string2.toString());
            }
            string = v0;
        } else {
            string = GitBuildServiceKt.access$getRemotes(this$0.getGit()).contains("origin") ? "origin" : (String)CollectionsKt.firstOrNull((List)GitBuildServiceKt.access$getRemotes(this$0.getGit()));
        }
        if ((remote = string) == null) {
            boolean $i$a$-checkNotNull-GitBuildService$pushTag$1$22 = false;
            String $i$a$-checkNotNull-GitBuildService$pushTag$1$22 = "There is no remote repositories";
            throw new IllegalStateException($i$a$-checkNotNull-GitBuildService$pushTag$1$22.toString());
        }
        String semverWithTagPrefix = $projectTagPrefix + $version;
        Object[] objectArray = new Object[]{"git", "push", remote, semverWithTagPrefix};
        exec.commandLine(objectArray);
        return Unit.INSTANCE;
    }

    private static final void pushTag$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/javiersc/semver/project/gradle/plugin/services/GitBuildService$Companion;", "", "<init>", "()V", "register", "Lorg/gradle/api/provider/Provider;", "Lcom/javiersc/semver/project/gradle/plugin/services/GitBuildService;", "project", "Lorg/gradle/api/Project;", "register$semver_project_gradle_plugin", "semver-project-gradle-plugin"})
    @SourceDebugExtension(value={"SMAP\nGitBuildService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitBuildService.kt\ncom/javiersc/semver/project/gradle/plugin/services/GitBuildService$Companion\n+ 2 GradleApiKotlinDslExtensions_4xzlmchnjfhf5wwk67zexqao1.kt\norg/gradle/kotlin/dsl/GradleApiKotlinDslExtensions_4xzlmchnjfhf5wwk67zexqao1Kt\n*L\n1#1,114:1\n41#2:115\n*S KotlinDebug\n*F\n+ 1 GitBuildService.kt\ncom/javiersc/semver/project/gradle/plugin/services/GitBuildService$Companion\n*L\n88#1:115\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Provider<GitBuildService> register$semver_project_gradle_plugin(@NotNull Project project) {
            void configureAction$iv;
            void implementationType$iv;
            void name$iv;
            void $this$registerIfAbsent$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BuildServiceRegistry buildServiceRegistry = project.getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"getSharedServices(...)");
            BuildServiceRegistry buildServiceRegistry2 = buildServiceRegistry;
            String string = "gitTagBuildService";
            Class<GitBuildService> clazz = GitBuildService.class;
            Action action = arg_0 -> Companion.register$lambda$1(arg_0 -> Companion.register$lambda$0(project, arg_0), arg_0);
            boolean $i$f$registerIfAbsent = false;
            Provider provider = $this$registerIfAbsent$iv.registerIfAbsent((String)name$iv, (Class)implementationType$iv, (Action)configureAction$iv);
            Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"`registerIfAbsent`(`name\u2026.java, `configureAction`)");
            return provider;
        }

        private static final Unit register$lambda$0(Project $project, BuildServiceSpec buildService) {
            int n;
            Integer n2 = (Integer)SemverPropertyKt.getCommitsMaxCount($project).getOrNull();
            if (n2 != null) {
                n = n2;
            } else {
                Object object = SemverExtensionKt.getSemverExtension($project).getCommitsMaxCount().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                n = ((Number)object).intValue();
            }
            int commitsMaxCount2 = n;
            ((Params)buildService.getParameters()).getGitDir().set((Provider)SemverExtensionKt.getSemverExtension($project).getGitDir());
            ((Params)buildService.getParameters()).getCommitsMaxCount().set((Object)commitsMaxCount2);
            ((Params)buildService.getParameters()).getRemoteProperty().set(SemverPropertyKt.getRemoteProperty($project));
            buildService.getMaxParallelUsages().set((Object)1);
            return Unit.INSTANCE;
        }

        private static final void register$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/javiersc/semver/project/gradle/plugin/services/GitBuildService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "gitDir", "Lorg/gradle/api/file/RegularFileProperty;", "getGitDir", "()Lorg/gradle/api/file/RegularFileProperty;", "commitsMaxCount", "Lorg/gradle/api/provider/Property;", "", "getCommitsMaxCount", "()Lorg/gradle/api/provider/Property;", "remoteProperty", "", "getRemoteProperty", "semver-project-gradle-plugin"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public RegularFileProperty getGitDir();

        @NotNull
        public Property<Integer> getCommitsMaxCount();

        @NotNull
        public Property<String> getRemoteProperty();
    }
}

