/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert.impl;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAsserterImpl
implements JsonAsserter {
    private final Object jsonObject;

    public JsonAsserterImpl(Object jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public <T> JsonAsserter assertThat(String path, Matcher<T> matcher) {
        String reason = "When processing json path: " + path;
        if (PathUtil.isPathDefinite((String)path)) {
            MatcherAssert.assertThat((String)reason, (Object)JsonPath.readOne((Object)this.jsonObject, (String)path), matcher);
        } else {
            MatcherAssert.assertThat((String)reason, (Object)JsonPath.read((Object)this.jsonObject, (String)path), matcher);
        }
        return this;
    }

    @Override
    public <T> JsonAsserter assertEquals(String path, T expected) {
        return this.assertThat(path, Matchers.equalTo(expected));
    }

    @Override
    public JsonAsserter assertNull(String path) {
        return this.assertThat(path, Matchers.nullValue());
    }

    @Override
    public <T> JsonAsserter assertNotNull(String path) {
        return this.assertThat(path, Matchers.notNullValue());
    }

    @Override
    public JsonAsserter and() {
        return this;
    }
}

