/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonassert;

import com.jayway.jsonassert.JsonAsserter;
import com.jayway.jsonassert.impl.JsonAsserterImpl;
import com.jayway.jsonassert.impl.matcher.CollectionMatcher;
import com.jayway.jsonassert.impl.matcher.IsCollectionWithSize;
import com.jayway.jsonassert.impl.matcher.IsEmptyCollection;
import com.jayway.jsonassert.impl.matcher.IsMapContainingKey;
import com.jayway.jsonassert.impl.matcher.IsMapContainingValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Map;
import org.hamcrest.Matcher;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonAssert {
    private static final JSONParser JSON_PARSER = new JSONParser();

    public static JsonAsserter with(String json) throws java.text.ParseException {
        try {
            return new JsonAsserterImpl(JSON_PARSER.parse(json));
        }
        catch (ParseException e) {
            throw new java.text.ParseException(json, e.getPosition());
        }
    }

    public static JsonAsserter with(Reader reader) throws java.text.ParseException, IOException {
        try {
            JsonAsserterImpl jsonAsserterImpl = new JsonAsserterImpl(JSON_PARSER.parse(reader));
            return jsonAsserterImpl;
        }
        catch (ParseException e) {
            throw new java.text.ParseException(e.toString(), e.getPosition());
        }
        finally {
            reader.close();
        }
    }

    public static JsonAsserter with(InputStream is) throws java.text.ParseException, IOException {
        InputStreamReader reader = new InputStreamReader(is);
        return JsonAssert.with(reader);
    }

    public static CollectionMatcher collectionWithSize(Matcher<? super Integer> sizeMatcher) {
        return new IsCollectionWithSize(sizeMatcher);
    }

    public static Matcher<Map<String, ?>> mapContainingKey(Matcher<String> keyMatcher) {
        return new IsMapContainingKey<String>(keyMatcher);
    }

    public static <V> Matcher<? super Map<?, V>> mapContainingValue(Matcher<? super V> valueMatcher) {
        return new IsMapContainingValue<V>(valueMatcher);
    }

    public static Matcher<Collection<Object>> emptyCollection() {
        return new IsEmptyCollection();
    }
}

